/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.EntityGraph;

import com.sun.ts.lib.harness.Fault;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.EntityGraph.Department;
import ee.jakarta.tck.persistence.core.EntityGraph.Employee;
import ee.jakarta.tck.persistence.core.EntityGraph.Employee2;
import ee.jakarta.tck.persistence.core.EntityGraph.Employee3;
import jakarta.persistence.AttributeNode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    Employee3[] empRef = new Employee3[5];
    Department[] deptRef = new Department[2];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Fault {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployeeData();
            this.displayMap(new Properties());
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Fault("Setup failed:", (Throwable)e);
        }
    }

    public void setupEmployeeData(String[] args, Properties p) throws Fault {
        this.logTrace("setupOrderData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createEmployeeData();
            this.displayMap(new Properties());
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Fault("Setup failed:", (Throwable)e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        super.cleanup();
    }

    public void cleanupEmployeeData() throws Fault {
        this.logTrace("Cleanup data");
        this.removeTestData();
        try {
            super.cleanup();
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    public void addAttributeNodesStringArrayTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("firstName");
        expected.add("lastName");
        EntityGraph empEG = this.getEntityManager().createEntityGraph(Employee.class);
        empEG.addAttributeNodes(expected.toArray(new String[0]));
        List result = empEG.getAttributeNodes();
        ArrayList<String> actual = new ArrayList<String>();
        for (AttributeNode an : result) {
            actual.add(an.getAttributeName());
        }
        if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
            this.logTrace("Received expected results");
            pass = true;
        } else {
            this.logErr("Expected results");
            for (String s : expected) {
                this.logErr("expected:" + s);
            }
            this.logErr("Actual results");
            for (String s : actual) {
                this.logErr("actual:" + s);
            }
        }
        if (!pass) {
            throw new Fault("addAttributeNodesStringArrayTest failed");
        }
    }

    public void addAttributeNodesStringArrayIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        EntityGraph empEG = this.getEntityManager().createEntityGraph(Employee2.class);
        try {
            empEG.addAttributeNodes(new String[]{"doesnotexist"});
            this.logErr("Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            this.logTrace("Received expected IllegalArgumentException");
        }
        if (!pass) {
            throw new Fault("addAttributeNodesStringArrayIllegalArgumentExceptionTest failed");
        }
    }

    public void addAttributeNodesAttributeArrayTest() throws Exception {
        boolean pass = false;
        Metamodel mm = this.getEntityManager().getMetamodel();
        ManagedType mTypeOrder = mm.managedType(Employee.class);
        ArrayList<String> sExpected = new ArrayList<String>();
        sExpected.add("firstName");
        sExpected.add("lastName");
        ArrayList<Attribute> expected = new ArrayList<Attribute>();
        for (String s : sExpected) {
            expected.add(mTypeOrder.getDeclaredAttribute(s));
        }
        EntityGraph empEG = this.getEntityManager().createEntityGraph(Employee.class);
        empEG.addAttributeNodes(expected.toArray(new Attribute[0]));
        List result = empEG.getAttributeNodes();
        ArrayList<String> actual = new ArrayList<String>();
        for (AttributeNode an : result) {
            actual.add(an.getAttributeName());
        }
        if (actual.containsAll(sExpected) && sExpected.containsAll(actual) && actual.size() == sExpected.size()) {
            this.logTrace("Received expected results");
            pass = true;
        } else {
            this.logErr("Expected results");
            for (String s : sExpected) {
                this.logErr("expected:" + s);
            }
            this.logErr("Actual results");
            for (String s : actual) {
                this.logErr("actual:" + s);
            }
        }
        if (!pass) {
            throw new Fault("addAttributeNodesAttributeArrayTest failed");
        }
    }

    public void createEntityGraphStringTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Test that the named entity graph is returned");
        EntityGraph eg = this.getEntityManager().createEntityGraph("first_last_graph");
        if (eg != null) {
            this.logTrace("Received non-null EntityGraph:" + eg.getName());
            pass1 = true;
        } else {
            this.logErr("Null was returned for EntityGraph that does exist");
        }
        this.logMsg("Test that null is returned");
        try {
            eg = this.getEntityManager().createEntityGraph("doesnotexist");
            if (eg == null) {
                this.logTrace("Received expected null EntityGraph");
                pass2 = true;
            } else {
                this.logErr("Non-null EntityGraph was returned instead of a null:" + eg.getName());
            }
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception", ex);
        }
        if (!pass1 || !pass2) {
            throw new Fault("createEntityGraphStringTest failed");
        }
    }

    public void getEntityGraphStringTest() throws Exception {
        boolean pass = false;
        EntityGraph eg = this.getEntityManager().getEntityGraph("first_last_graph");
        if (eg != null) {
            this.logTrace("Received non-null EntityGraph:" + eg.getName());
            pass = true;
        } else {
            this.logErr("Null was returned for EntityGraph that does exist");
        }
        if (!pass) {
            throw new Fault("getEntityGraphStringTest failed");
        }
    }

    public void entityGraphGetNameTest() throws Exception {
        boolean pass = false;
        String expected = "first_last_graph";
        EntityGraph eg = this.getEntityManager().getEntityGraph(expected);
        if (eg != null) {
            if (eg.getName().equals(expected)) {
                this.logTrace("Received expected EntityGraph name:" + eg.getName());
                pass = true;
            } else {
                this.logErr("Expected name: " + expected + ", actual:" + eg.getName());
            }
        } else {
            this.logErr("Null was returned for EntityGraph that does exist");
        }
        if (!pass) {
            throw new Fault("entityGraphGetNameTest failed");
        }
    }

    public void entityGraphGetNameNoNameExistsTest() throws Exception {
        boolean pass = false;
        List egs = this.getEntityManager().getEntityGraphs(Employee2.class);
        if (egs.size() == 1) {
            EntityGraph e = (EntityGraph)egs.get(0);
            if (e.getName().equals("Employee2")) {
                this.logTrace("Received expected name:" + e.getName());
                pass = true;
            } else {
                this.logErr("Expected name: Employee2, actual:" + e.getName());
            }
        } else {
            this.logErr("Expected 1 graph to be returned, instead got:" + egs.size());
        }
        if (!pass) {
            throw new Exception("entityGraphGetNameNoNameExistsTest failed");
        }
    }

    public void getNameTest() throws Exception {
        boolean pass = false;
        EntityGraph eg = this.getEntityManager().createEntityGraph(Employee2.class);
        if (eg.getName() == null) {
            this.logTrace("Received expected null");
            pass = true;
        } else {
            this.logErr("Expected name: null, actual:" + eg.getName());
        }
        if (!pass) {
            throw new Exception("getNameTest failed");
        }
    }

    public void getEntityGraphStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityManager().getEntityGraph("doesnotexist");
            this.logErr("Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            this.logTrace("Received expected IllegalArgumentException");
        }
        if (!pass) {
            throw new Exception("getEntityGraphStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getEntityGraphsClassTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("first_last_graph");
        expected.add("last_salary_graph");
        expected.add("lastname_department_subgraphs");
        ArrayList<String> actual = new ArrayList<String>();
        List eg = this.getEntityManager().getEntityGraphs(Employee3.class);
        if (eg.size() > 0) {
            for (EntityGraph e : eg) {
                actual.add(e.getName());
            }
            if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
                this.logTrace("Received expected results");
                pass = true;
            } else {
                this.logErr("Expected results");
                for (String s : expected) {
                    this.logErr("expected:" + s);
                }
                this.logErr("Actual results");
                for (String s : actual) {
                    this.logErr("actual:" + s);
                }
            }
        } else {
            this.logErr("No named entity graphs were returned eventhough they exist in entity");
        }
        if (!pass) {
            throw new Exception("getEntityGraphsClassTest failed");
        }
    }

    public void addNamedEntityGraphStringEntityGraphTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        String sExpected = "new_named_entity_graph";
        this.logMsg("add entity graph to EMF");
        EntityGraph eg = this.getEntityManager().createEntityGraph(Employee.class);
        eg.addAttributeNodes(new String[]{"id"});
        this.getEntityManager().getEntityManagerFactory().addNamedEntityGraph(sExpected, eg);
        EntityGraph eg2 = this.getEntityManager().getEntityGraph(sExpected);
        if (eg2 != null) {
            if (eg2.getName() != null) {
                if (eg2.getName().equals(sExpected)) {
                    this.logTrace("Received expected entity graph:" + eg2.getName());
                    pass1 = true;
                } else {
                    this.logErr("Expected: named_entity_graph, actual:" + eg2.getName());
                }
            } else {
                this.logErr("getName() returned null for a named entity graph added via addNamedEntityGraph");
            }
        } else {
            this.logErr("getEntityGraph() returned null");
        }
        this.logMsg("verify nodes");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        ArrayList<String> actual = new ArrayList<String>();
        List listNodes = eg2.getAttributeNodes();
        for (AttributeNode an : listNodes) {
            actual.add(an.getAttributeName());
        }
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            this.logTrace("Received expected AttributeNode");
            pass2 = true;
        } else {
            this.logErr("Did not received expected AttributeNodes");
            this.logErr("Expected results");
            for (String s : expected) {
                this.logErr("expected:" + s);
            }
            this.logErr("Actual results");
            for (String s : actual) {
                this.logErr("actual:" + s);
            }
        }
        this.logMsg("override previous entity graph");
        eg = this.getEntityManager().createEntityGraph(Employee.class);
        eg.addAttributeNodes(new String[]{"lastName"});
        this.getEntityManager().getEntityManagerFactory().addNamedEntityGraph(sExpected, eg);
        eg2 = this.getEntityManager().getEntityGraph(sExpected);
        if (eg2 != null) {
            if (eg2.getName() != null) {
                if (eg2.getName().equals(sExpected)) {
                    this.logTrace("Received expected entity graph:" + eg2.getName());
                    pass3 = true;
                } else {
                    this.logErr("Expected: named_entity_graph, actual:" + eg2.getName());
                }
            } else {
                this.logErr("getName() returned null for a named entity graph added via addNamedEntityGraph");
            }
        } else {
            this.logErr("getEntityGraph() returned null");
        }
        this.logMsg("verify nodes of overriden named entity graph");
        expected = new ArrayList();
        expected.add("lastName");
        actual = new ArrayList();
        listNodes = eg2.getAttributeNodes();
        for (AttributeNode an : listNodes) {
            actual.add(an.getAttributeName());
        }
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            this.logTrace("Received expected AttributeNode");
            pass4 = true;
        } else {
            this.logErr("Did not received expected AttributeNodes");
            this.logErr("Expected results");
            for (String s : expected) {
                this.logErr("expected:" + s);
            }
            this.logErr("Actual results");
            for (String s : actual) {
                this.logErr("actual:" + s);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("addNamedEntityGraphStringEntityGraphTest failed");
        }
    }

    public void getEntityGraphsClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityManager().getEntityGraphs(Client.class);
            this.logErr("Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            this.logTrace("Received expected IllegalArgumentException");
        }
        if (!pass) {
            throw new Exception("getEntityGraphsClassIllegalArgumentExceptionTest failed");
        }
    }

    public void annotationsTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("lastName");
        expected.add("salary");
        ArrayList<String> actual = new ArrayList<String>();
        EntityGraph eg = this.getEntityManager().getEntityGraph("last_salary_graph");
        List listNodes = eg.getAttributeNodes();
        for (AttributeNode an : listNodes) {
            actual.add(an.getAttributeName());
        }
        if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
            this.logTrace("Received expected results");
            pass = true;
        } else {
            this.logErr("Expected results");
            for (String s : expected) {
                this.logErr("expected:" + s);
            }
            this.logErr("Actual results");
            for (String s : actual) {
                this.logErr("actual:" + s);
            }
        }
        if (!pass) {
            throw new Exception("annotationsTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.deptRef[0] = new Department(1, "Marketing");
            this.deptRef[1] = new Department(2, "Administration");
            for (Department department : this.deptRef) {
                this.getEntityManager().persist((Object)department);
                this.logTrace("persisted department:" + String.valueOf(department));
            }
            this.empRef[0] = new Employee3(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[1] = new Employee3(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[0]);
            this.empRef[2] = new Employee3(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[1]);
            this.empRef[3] = new Employee3(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[1]);
            this.empRef[4] = new Employee3(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[1]);
            for (Serializable serializable : this.empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted employee3:" + String.valueOf(serializable));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

