/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.cdi.customizedmapping.adapters;

import ee.jakarta.tck.json.bind.cdi.customizedmapping.adapters.model.AnimalShelterInjectedAdapter;
import ee.jakarta.tck.json.bind.customizedmapping.adapters.model.Animal;
import ee.jakarta.tck.json.bind.customizedmapping.adapters.model.Cat;
import ee.jakarta.tck.json.bind.customizedmapping.adapters.model.Dog;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AdaptersCustomizationCDITest {
    private static SeContainer container;

    @BeforeAll
    private static void startContainer() {
        try {
            CDI.current();
        }
        catch (IllegalStateException exception) {
            container = SeContainerInitializer.newInstance().initialize();
        }
    }

    @AfterAll
    private static void stopContainer() {
        if (container != null) {
            container.close();
        }
    }

    @Test
    public void testCDISupport() {
        Jsonb jsonb = JsonbBuilder.create();
        String validationPattern = "\\{\\s*\"animals\"\\s*:\\s*\\[\\s*\\{\\s*\"age\"\\s*:\\s*5\\s*,\\s*\"cuddly\"\\s*:\\s*true\\s*,\\s*\"furry\"\\s*:\\s*true\\s*,\\s*\"name\"\\s*:\\s*\"Garfield\"\\s*,\\s*\"type\"\\s*:\\s*\"CAT\"\\s*,\\s*\"weight\"\\s*:\\s*10.5\\s*}\\s*,\\s*\\{\\s*\"age\"\\s*:\\s*3\\s*,\\s*\"barking\"\\s*:\\s*true\\s*,\\s*\"furry\"\\s*:\\s*false\\s*,\\s*\"name\"\\s*:\\s*\"Milo\"\\s*,\\s*\"type\"\\s*:\\s*\"DOG\"\\s*,\\s*\"weight\"\\s*:\\s*5.5\\s*}\\s*,\\s*\\{\\s*\"age\"\\s*:\\s*6\\s*,\\s*\"furry\"\\s*:\\s*false\\s*,\\s*\"name\"\\s*:\\s*\"Tweety\"\\s*,\\s*\"type\"\\s*:\\s*\"GENERIC\"\\s*,\\s*\"weight\"\\s*:\\s*0.5\\s*}\\s*]\\s*}";
        AnimalShelterInjectedAdapter animalShelter = new AnimalShelterInjectedAdapter();
        animalShelter.addAnimal(new Cat(5, "Garfield", 10.5f, true, true));
        animalShelter.addAnimal(new Dog(3, "Milo", 5.5f, false, true));
        animalShelter.addAnimal(new Animal(6, "Tweety", 0.5f, false));
        String jsonString = jsonb.toJson((Object)animalShelter);
        MatcherAssert.assertThat((String)"Failed to correctly marshall complex type hierarchy using an adapter with a CDI managed field configured using JsonbTypeAdapter annotation to a simpler class.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)validationPattern));
        String toSerialize = "{ \"animals\" : [ { \"age\" : 5, \"cuddly\" : true, \"furry\" : true, \"name\" : \"Garfield\" , \"type\" : \"CAT\", \"weight\" : 10.5}, { \"age\" : 3, \"barking\" : true, \"furry\" : false, \"name\" : \"Milo\", \"type\" : \"DOG\", \"weight\" : 5.5}, { \"age\" : 6, \"furry\" : false, \"name\" : \"Tweety\", \"type\" : \"GENERIC\", \"weight\" : 0.5} ] }";
        AnimalShelterInjectedAdapter unmarshalledObject = (AnimalShelterInjectedAdapter)jsonb.fromJson(toSerialize, AnimalShelterInjectedAdapter.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshall complex type hierarchy using an adapter with a CDI managed field configured using JsonbTypeAdapter annotation to a simpler class.", (Object)unmarshalledObject, (Matcher)Matchers.is((Object)animalShelter));
    }
}

