/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.pluggability.jsonprovidertests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import ee.jakarta.tck.jsonp.provider.MyJsonGenerator;
import ee.jakarta.tck.jsonp.provider.MyJsonProvider;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonException;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final String MY_JSONPROVIDER_CLASS = "ee.jakarta.tck.jsonp.provider.MyJsonProvider";
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());
    private String providerPath = null;

    @AfterEach
    public void after() {
        MyJsonProvider.clearCalls();
        MyJsonGenerator.clearCalls();
    }

    @Test
    public void jsonProviderTest1() {
        boolean pass = true;
        try {
            JsonProvider provider = JsonProvider.provider();
            String providerClass = provider.getClass().getName();
            LOGGER.info("provider class=" + providerClass);
            if (providerClass.equals(MY_JSONPROVIDER_CLASS)) {
                LOGGER.info("Current provider is my provider - expected.");
            } else {
                LOGGER.warning("Current provider is not my provider - unexpected.");
                pass = false;
                ServiceLoader<JsonProvider> loader = ServiceLoader.load(JsonProvider.class);
                Iterator<JsonProvider> it = loader.iterator();
                ArrayList<JsonProvider> providers = new ArrayList<JsonProvider>();
                while (it.hasNext()) {
                    providers.add(it.next());
                }
                LOGGER.info("Providers: " + providers);
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest1 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonProviderTest1 Failed");
    }

    @Test
    public void jsonProviderTest2() {
        boolean pass = true;
        String expString = "public JsonGenerator createGenerator(Writer)";
        String expString2 = "public JsonGenerator writeStartArray()";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonGenerator generator = Json.createGenerator((Writer)new StringWriter());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals((String)expString, (String)actString);
            generator.writeStartArray();
            String actString2 = MyJsonGenerator.getCalls();
            LOGGER.info("Verify SPI generator method was called: " + expString2);
            pass = JSONP_Util.assertEquals((String)expString2, (String)actString2);
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest2 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonProviderTest2 Failed");
    }

    @Test
    public void jsonProviderTest3() {
        boolean pass = true;
        String expString = "public JsonGenerator createGenerator(OutputStream)";
        String expString2 = "public JsonGenerator writeStartObject()";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonGenerator generator = Json.createGenerator((OutputStream)new ByteArrayOutputStream());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals((String)expString, (String)actString);
            generator.writeStartObject();
            String actString2 = MyJsonGenerator.getCalls();
            LOGGER.info("Verify SPI generator method was called: " + expString2);
            pass = JSONP_Util.assertEquals((String)expString2, (String)actString2);
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest3 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonProviderTest3 Failed");
    }

    @Test
    public void jsonProviderTest4() {
        String expString = "public JsonParser createParser(Reader)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonParser parser = Json.createParser((Reader)new StringReader("{}"));
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest4 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest4 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest5() {
        String expString = "public JsonParser createParser(InputStream)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonParser parser = Json.createParser((InputStream)JSONP_Util.getInputStreamFromString((String)"{}"));
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest5 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest5 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest6() {
        String expString = "public JsonParserFactory createParserFactory(Map<String, ?>)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonParserFactory parserFactory = Json.createParserFactory((Map)JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest5 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest6 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest7() {
        String expString = "public JsonParserFactory createParserFactory(Map<String, ?>)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonParserFactory parserFactory = Json.createParserFactory(new HashMap());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest7 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest7 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest8() {
        String expString = "public JsonGeneratorFactory createGeneratorFactory(Map<String, ?>)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(new HashMap());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest8 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest8 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest9() {
        String expString = "public JsonWriterFactory createWriterFactory(Map<String, ?>)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonWriterFactory factory = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest9 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest9 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest10() {
        String expString = "public JsonParser createParser(InputStream)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            InputStream in = null;
            JsonParser parser = Json.createParser(in);
            Assertions.fail((String)"jsonProviderTest10 Failed");
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException: " + e);
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest10 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest11() {
        String expString = "public JsonArrayBuilder createArrayBuilder()";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest11 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest11 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest12() {
        String expString = "public JsonObjectBuilder createObjectBuilder()";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest12 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest12 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest13() {
        String expString = "public JsonBuilderFactory createBuilderFactory(Map<String, ?>)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonBuilderFactory objectBuilder = Json.createBuilderFactory((Map)JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest13 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest13 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest14() {
        String expString = "public JsonReader createReader(Reader)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonReader reader = Json.createReader((Reader)new StringReader("{}"));
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest14 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest14 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest15() {
        String expString = "public JsonReader createReader(InputStream)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonReader reader = Json.createReader((InputStream)JSONP_Util.getInputStreamFromString((String)"{}"));
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest15 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest15 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest16() {
        String expString = "public JsonWriter createWriter(Writer)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonWriter writer = Json.createWriter((Writer)new StringWriter());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest16 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest16 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest17() {
        String expString = "public JsonWriter createWriter(OutputStream)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonWriter writer = Json.createWriter((OutputStream)new ByteArrayOutputStream());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest17 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest17 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonProviderTest18() {
        String expString = "public JsonReaderFactory createReaderFactory(Map<String, ?>)";
        try {
            LOGGER.info("Calling SPI provider method: " + expString);
            JsonReaderFactory factory = Json.createReaderFactory((Map)JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            LOGGER.info("Verify SPI provider method was called: " + expString);
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expString, (String)actString), (String)"jsonProviderTest18 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonProviderTest18 Failed: ", (Throwable)e);
        }
    }
}

