/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.uriinfo;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.core.uriinfo.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.core.uriinfo.URIInfoTest;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -5479757659703717839L;
    protected static final String ROOT = "jaxrs_ee_core_uriinfo_web";
    protected static final String RESOURCE = "resource";

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_core_uriinfo_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/core/uriinfo/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_uriinfo_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, URIInfoTest.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void queryTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "query?stringtest=cts&inttest=-2147483648?"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "stringtest=cts|inttest=-2147483648?");
        this.invoke();
    }

    @Test
    public void queryTest1() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "query1?stringtest=cts%20&inttest=-2147483648?%2010"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "stringtest=cts |inttest=-2147483648? 10");
        this.invoke();
    }

    @Test
    public void queryTest2() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "query2?stringtest=cts%20&inttest=-2147483648%2010"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "stringtest=cts%20|inttest=-2147483648%2010");
        this.invoke();
    }

    @Test
    public void aPathTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "apath"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "http://" + this._hostname + ":" + this._port + this.getContextRoot() + "/apath");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FAILED");
        this.invoke();
    }

    @Test
    public void baseUriTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "baseuri"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "http://" + this._hostname + ":" + this._port + "/jaxrs_ee_core_uriinfo_web");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FAILED");
        this.invoke();
    }

    @Test
    public void pathTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "path"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "resource/path");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, ROOT);
        this.invoke();
    }

    @Test
    public void pathTest1() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "path1%20/%2010"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "resource/path1 / 10");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, ROOT);
        this.invoke();
    }

    @Test
    public void pathTest2() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "path2%20/%2010"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "resource/path2%20/%2010");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, ROOT);
        this.invoke();
    }

    @Test
    public void pathSegTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "pathseg"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, RESOURCE);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "pathseg");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, ROOT);
        this.invoke();
    }

    @Test
    public void pathSegTest1() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "pathseg1%20/%2010"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, RESOURCE);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "pathseg1 / 10/");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, ROOT);
        this.invoke();
    }

    @Test
    public void pathSegTest2() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "pathseg2%20/%2010"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, RESOURCE);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "pathseg2%20/%2010/");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, ROOT);
        this.invoke();
    }

    @Test
    public void pathParamTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "pathparam/a/b"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "a=a|b=b");
        this.invoke();
    }

    @Test
    public void pathParamTest1() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "pathparam1/%20/%2010"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "a= |b= 10");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, ROOT);
        this.invoke();
    }

    @Test
    public void pathParamTest2() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "pathparam2/%20/%2010"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "a=%20|b=%2010");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, ROOT);
        this.invoke();
    }

    @Test
    public void requestURITest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "request?stringtest=cts&inttest=-2147483648"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "http://" + this._hostname + ":" + this._port + this.getContextRoot() + "/request?stringtest=cts&inttest=-2147483648");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "FAILED");
        this.invoke();
    }

    @Test
    public void getMatchedResourcesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", RESOURCE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, URIInfoTest.class.getName());
        this.invoke();
    }

    @Test
    public void getMatchedURIsTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "uri"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "resource/uri");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, RESOURCE);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "number=2");
        this.invoke();
    }

    @Test
    public void getMatchedURIsTest1() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "uri1"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "resource/uri1");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, RESOURCE);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "number=2");
        this.invoke();
    }

    @Test
    public void getMatchedURIsTest2() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "uri2"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "resource/uri2");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, RESOURCE);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "number=2");
        this.invoke();
    }

    @Test
    public void getNormalizedUriTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "PQR09pqr/~-._"));
        this.invoke();
        this.assertBodyGreaterThanOne();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "%50%51%52%30%39%70%71%72/%7e%2d%2E%5f"));
        this.invoke();
        this.assertBodyGreaterThanOne();
    }

    private void assertBodyGreaterThanOne() throws JAXRSCommonClient.Fault {
        int i = Integer.parseInt(this.getResponseBody());
        Assertions.assertTrue((i > 1 ? 1 : 0) != 0, (String)("Got unexpected response body" + this.getResponseBody()));
    }
}

