/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.AndExprKeywords;
import com.sun.javatest.ExprKeywords;
import com.sun.javatest.Keywords;
import com.sun.javatest.NotExprKeywords;
import com.sun.javatest.OrExprKeywords;
import com.sun.javatest.ParenExprKeywords;
import com.sun.javatest.TermExprKeywords;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.Set;

class ExprParser {
    protected static boolean allowNumericKeywords = Boolean.getBoolean("javatest.allowNumericKeywords");
    private String text;
    private Set validKeywords;
    private int index;
    private int token;
    private String idValue;
    private static final int ID = 0;
    private static final int AND = 1;
    private static final int OR = 2;
    private static final int NOT = 3;
    private static final int LPAREN = 4;
    private static final int RPAREN = 5;
    private static final int END = 6;
    private static final int ERROR = 7;
    private static I18NResourceBundle i18n = Keywords.i18n;

    ExprParser(String text, Set validKeywords) {
        this.text = text;
        this.validKeywords = validKeywords;
        this.nextToken();
    }

    ExprKeywords parse() throws Keywords.Fault {
        if (this.text == null || this.text.trim().length() == 0) {
            throw new Keywords.Fault(i18n, "kw.noExpr");
        }
        ExprKeywords e = this.parseExpr();
        this.expect(6);
        return e;
    }

    ExprKeywords parseExpr() throws Keywords.Fault {
        block4: for (ExprKeywords e = this.parseTerm(); e != null; e = e.order()) {
            switch (this.token) {
                case 1: {
                    this.nextToken();
                    e = new AndExprKeywords(e, this.parseTerm());
                    continue block4;
                }
                case 2: {
                    this.nextToken();
                    e = new OrExprKeywords(e, this.parseTerm());
                    continue block4;
                }
                default: {
                    return e;
                }
            }
        }
        return null;
    }

    ExprKeywords parseTerm() throws Keywords.Fault {
        switch (this.token) {
            case 0: {
                String id = this.idValue;
                if (this.validKeywords != null && !this.validKeywords.contains(id)) {
                    throw new Keywords.Fault(i18n, "kw.invalidKeyword", id);
                }
                this.nextToken();
                return new TermExprKeywords(id);
            }
            case 3: {
                this.nextToken();
                return new NotExprKeywords(this.parseTerm());
            }
            case 4: {
                this.nextToken();
                ExprKeywords e = this.parseExpr();
                this.expect(5);
                return new ParenExprKeywords(e);
            }
        }
        throw new Keywords.Fault(i18n, "kw.badKeywordExpr");
    }

    private void expect(int t) throws Keywords.Fault {
        if (t != this.token) {
            throw new Keywords.Fault(i18n, "kw.badKeywordExpr");
        }
        this.nextToken();
    }

    private void nextToken() {
        block8: while (this.index < this.text.length()) {
            char c = this.text.charAt(this.index++);
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block8;
                }
                case '&': {
                    this.token = 1;
                    return;
                }
                case '|': {
                    this.token = 2;
                    return;
                }
                case '!': {
                    this.token = 3;
                    return;
                }
                case '(': {
                    this.token = 4;
                    return;
                }
                case ')': {
                    this.token = 5;
                    return;
                }
            }
            if (Character.isUnicodeIdentifierStart(c) || allowNumericKeywords && Character.isDigit(c)) {
                this.idValue = String.valueOf(Character.toLowerCase(c));
                while (this.index < this.text.length() && Character.isUnicodeIdentifierPart(this.text.charAt(this.index))) {
                    char ch;
                    if (Character.isIdentifierIgnorable(ch = this.text.charAt(this.index++))) continue;
                    this.idValue = this.idValue + Character.toLowerCase(ch);
                }
                this.token = 0;
                return;
            }
            this.token = 7;
            return;
        }
        this.token = 6;
    }
}

