/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.javatest;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvContext;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.ts.lib.javatest.TSLegacyParameters;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;

public class TSEnvironmentInterview
extends Interview
implements Parameters.LegacyEnvParameters {
    private FileListQuestion qEnvFiles = new FileListQuestion(this, "envFiles"){
        {
            this.setFilter((FileFilter)new ExtensionFileFilter(".jte", "Environment File"));
            this.setValue(new File[]{new File(TSLegacyParameters.TS_HOME, "bin/ts.jte")});
        }

        public File getBaseDirectory() {
            TestSuite ts = TSEnvironmentInterview.this.parent.getTestSuite();
            if (ts == null) {
                return null;
            }
            File r = ts.getRoot();
            return r.isDirectory() ? r : r.getParentFile();
        }

        protected Question getNext() {
            TSEnvironmentInterview.this.updateCachedEnvTable();
            if (TSEnvironmentInterview.this.cachedEnvTableError != null) {
                return TSEnvironmentInterview.this.qEnvTableError;
            }
            if (TSEnvironmentInterview.this.cachedEnvTable == null || TSEnvironmentInterview.this.cachedEnvTable.getEnvNames().length == 0) {
                return TSEnvironmentInterview.this.qNoEnvs;
            }
            return TSEnvironmentInterview.this.qEnv;
        }
    };
    private TestEnvContext cachedEnvTable;
    private File[] cachedEnvTable_absFiles;
    private String cachedEnvTableError;
    private ErrorQuestion qNoEnvs = new ErrorQuestion((Interview)this, "noEnvs");
    private ErrorQuestion qEnvTableError = new ErrorQuestion(this, "envTableError"){

        protected Object[] getTextArgs() {
            return new Object[]{TSEnvironmentInterview.this.cachedEnvTableError};
        }
    };
    private StringQuestion qEnv = new StringQuestion(this, "env"){
        private TestEnvContext cachedEnvTable;
        {
            if (TSLegacyParameters.OS.toUpperCase().startsWith("WIN")) {
                this.setValue("ts_win32");
            } else {
                this.setValue("ts_unix");
            }
        }

        public String[] getSuggestions() {
            TestEnvContext envTable = TSEnvironmentInterview.this.getEnvTable();
            if (envTable != this.cachedEnvTable) {
                Object[] envNames;
                if (envTable == null) {
                    envNames = TestUtil.EMPTY_STRING_ARRAY;
                } else {
                    Object[] names = envTable.getEnvMenuNames();
                    Arrays.sort(names);
                    envNames = names;
                }
                this.setSuggestions((String[])envNames);
                this.cachedEnvTable = envTable;
            }
            return super.getSuggestions();
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            TSEnvironmentInterview.this.updateCachedEnv();
            if (TSEnvironmentInterview.this.cachedEnv == null) {
                return TSEnvironmentInterview.this.cachedEnvError;
            }
            return TSEnvironmentInterview.this.qEnd;
        }
    };
    private TestEnvironment cachedEnv;
    private TestEnvContext cachedEnv_envTable;
    private String cachedEnv_envName;
    private Question cachedEnvError;
    private Object[] cachedEnvErrorArgs;
    private ErrorQuestion qEnvError = new ErrorQuestion(this, "envError"){

        protected Object[] getTextArgs() {
            return TSEnvironmentInterview.this.cachedEnvErrorArgs;
        }
    };
    private ErrorQuestion qEnvNotFound = new ErrorQuestion(this, "envNotFound"){

        protected Object[] getTextArgs() {
            return TSEnvironmentInterview.this.cachedEnvErrorArgs;
        }
    };
    private ErrorQuestion qEnvUndefinedEntry = new ErrorQuestion(this, "envUndefinedEntry"){

        protected Object[] getTextArgs() {
            return TSEnvironmentInterview.this.cachedEnvErrorArgs;
        }
    };
    private Question qEnd = new FinalQuestion((Interview)this);
    private InterviewParameters parent;

    public TSEnvironmentInterview(InterviewParameters parent) throws Interview.Fault {
        super((Interview)parent, "environment");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setFirstQuestion((Question)this.qEnvFiles);
    }

    public File[] getEnvFiles() {
        return this.qEnvFiles.getValue();
    }

    public File[] getAbsoluteEnvFiles() {
        return TSEnvironmentInterview.getAbsoluteFiles(this.parent.getTestSuite().getRootDir(), this.getEnvFiles());
    }

    public void setEnvFiles(File[] files) {
        this.qEnvFiles.setValue(files);
    }

    public String getEnvName() {
        return this.qEnv.getValue();
    }

    public void setEnvName(String name) {
        this.qEnv.setValue(name);
    }

    public TestEnvironment getEnv() {
        this.updateCachedEnv();
        return this.cachedEnv;
    }

    private TestEnvContext getEnvTable() {
        this.updateCachedEnvTable();
        return this.cachedEnvTable;
    }

    private void updateCachedEnvTable() {
        File[] absFiles = this.getAbsoluteEnvFiles();
        if (!TSEnvironmentInterview.equal(this.cachedEnvTable_absFiles, absFiles)) {
            try {
                this.cachedEnvTable = new TestEnvContext(absFiles);
                this.cachedEnvTableError = null;
            }
            catch (TestEnvContext.Fault e) {
                e.printStackTrace();
                this.cachedEnvTable = null;
                this.cachedEnvTableError = e.getMessage();
            }
            this.cachedEnvTable_absFiles = absFiles;
        }
    }

    private void updateCachedEnv() {
        TestEnvContext envTable = this.getEnvTable();
        String envName = this.getEnvName();
        if (this.cachedEnv_envTable != envTable || !TSEnvironmentInterview.equal(this.cachedEnv_envName, envName)) {
            try {
                if (envTable == null || envName == null || envName.length() == 0) {
                    this.cachedEnv = null;
                    this.cachedEnvError = null;
                } else {
                    this.cachedEnv = envTable.getEnv(envName);
                    if (this.cachedEnv == null) {
                        this.cachedEnvError = this.qEnvNotFound;
                        this.cachedEnvErrorArgs = new Object[]{envName};
                    } else {
                        this.cachedEnvError = null;
                        this.cachedEnvErrorArgs = null;
                        Iterator i = this.cachedEnv.elements().iterator();
                        while (i.hasNext() && this.cachedEnvError == null) {
                            TestEnvironment.Element entry = (TestEnvironment.Element)i.next();
                            if (entry.getValue().indexOf("VALUE_NOT_DEFINED") < 0) continue;
                            this.cachedEnv = null;
                            String eText = (String)(entry.getDefinedInEnv() == null ? "" : "env." + entry.getDefinedInEnv() + ".") + entry.getKey() + "=" + entry.getValue();
                            this.cachedEnvError = this.qEnvUndefinedEntry;
                            this.cachedEnvErrorArgs = new Object[]{eText, entry.getDefinedInFile()};
                        }
                    }
                }
            }
            catch (TestEnvironment.Fault e) {
                this.cachedEnv = null;
                this.cachedEnvError = this.qEnvError;
                this.cachedEnvErrorArgs = new Object[]{e.getMessage()};
            }
            this.cachedEnv_envTable = envTable;
            this.cachedEnv_envName = envName;
        }
    }

    private static File[] getAbsoluteFiles(File baseDir, File[] files) {
        if (files == null) {
            return null;
        }
        boolean allAbsolute = true;
        for (int i = 0; i < files.length && allAbsolute; ++i) {
            allAbsolute = files[i].isAbsolute();
        }
        if (allAbsolute) {
            return files;
        }
        File[] absoluteFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            absoluteFiles[i] = f.isAbsolute() ? f : new File(baseDir, f.getPath());
        }
        return absoluteFiles;
    }

    private static boolean equal(File f1, File f2) {
        return f1 == null ? f2 == null : f1.equals(f2);
    }

    private static boolean equal(File[] f1, File[] f2) {
        if (f1 == null || f2 == null) {
            return f1 == f2;
        }
        if (f1.length != f2.length) {
            return false;
        }
        for (int i = 0; i < f1.length; ++i) {
            if (f1[i] == f2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }
}

