/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.ext.runtimedelegate.create;

import com.sun.net.httpserver.HttpHandler;
import ee.jakarta.tck.ws.rs.api.rs.ext.runtimedelegate.create.Resource;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 24421214489103680L;
    transient RuntimeDelegate delegate = RuntimeDelegate.getInstance();

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void createEndpointTest() throws JAXRSCommonClient.Fault {
        Application application = new Application(){

            public Set<Class<?>> getClasses() {
                HashSet set = new HashSet();
                set.add(Resource.class);
                return set;
            }
        };
        RuntimeDelegate delegate = RuntimeDelegate.getInstance();
        HttpHandler handler = null;
        try {
            handler = (HttpHandler)delegate.createEndpoint(application, HttpHandler.class);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
            return;
        }
        catch (UnsupportedOperationException e) {
            JAXRSClientIT.logMsg("UnsupportedOperationException has been thrown as expected", e);
            return;
        }
        JAXRSClientIT.assertNotNull(handler, "HttpHandler end point should be created, or an exception thrown otherwise");
        JAXRSClientIT.logMsg("HttpHandler endpoint has been sucessfully created");
    }

    @Test
    public void createEndpointThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            this.delegate.createEndpoint((Application)null, HttpHandler.class);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
        }
    }

    @Test
    public void checkCreatedUriBuilderTest() throws JAXRSCommonClient.Fault {
        UriBuilder builder = this.delegate.createUriBuilder();
        Assertions.assertTrue((builder != null ? 1 : 0) != 0, (String)"UriBuilder has not been created");
    }

    @Test
    public void checkCreatedVariantListBuilderTest() throws JAXRSCommonClient.Fault {
        Variant.VariantListBuilder builder = this.delegate.createVariantListBuilder();
        Assertions.assertTrue((builder != null ? 1 : 0) != 0, (String)"VariantListBuilder has not been created");
    }

    @Test
    public void checkCreatedResponseBuilderTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.delegate.createResponseBuilder();
        Assertions.assertTrue((builder != null ? 1 : 0) != 0, (String)"ResponseBuilderTest has not been created");
    }

    @Test
    public void checkCreatedHeaderDelegateCookieTest() throws JAXRSCommonClient.Fault {
        String cookieName = "cookieName";
        String cookieValue = "cookieValue";
        RuntimeDelegate.HeaderDelegate hdc = this.delegate.createHeaderDelegate(Cookie.class);
        Assertions.assertTrue((hdc != null ? 1 : 0) != 0, (String)"HeaderDelegate<Cookie> has not been created");
        Cookie cookie = new Cookie(cookieName, cookieValue);
        String result = hdc.toString((Object)cookie);
        Cookie serialized = (Cookie)hdc.fromString(result);
        Assertions.assertTrue((boolean)cookieName.equals(serialized.getName()), (String)"HeaderDelegate<Cookie> fromString(),toString() failed");
    }

    @Test
    public void checkCreatedHeaderDelegateCacheControlTest() throws JAXRSCommonClient.Fault {
        RuntimeDelegate.HeaderDelegate hdcc = this.delegate.createHeaderDelegate(CacheControl.class);
        Assertions.assertTrue((hdcc != null ? 1 : 0) != 0, (String)"HeaderDelegate<CacheControl> has not been created");
        CacheControl control = new CacheControl();
        control.setMaxAge(1000);
        control.setSMaxAge(500);
        control.setNoTransform(false);
        control.setPrivate(true);
        String toString = hdcc.toString((Object)control);
        CacheControl serialized = (CacheControl)hdcc.fromString(toString);
        Assertions.assertTrue((serialized.getMaxAge() == 1000 && serialized.getSMaxAge() == 500 && !serialized.isNoTransform() && serialized.isPrivate() ? 1 : 0) != 0, (String)"HeaderDelegate<CacheControl> fromString(),toString() failed");
    }

    @Test
    public void checkCreatedHeaderDelegateEntityTagTest() throws JAXRSCommonClient.Fault {
        String tagValue = "tagValue";
        RuntimeDelegate.HeaderDelegate hdet = this.delegate.createHeaderDelegate(EntityTag.class);
        Assertions.assertTrue((hdet != null ? 1 : 0) != 0, (String)"HeaderDelegate<EntityTag> has not been created");
        EntityTag tag = new EntityTag(tagValue);
        String toString = hdet.toString((Object)tag);
        EntityTag serialized = (EntityTag)hdet.fromString(toString);
        Assertions.assertTrue((boolean)tagValue.equals(serialized.getValue()), (String)"HeaderDelegate<EntityTag> fromString(),toString() failed");
    }

    @Test
    public void checkCreatedHeaderDelegateNewCookieTest() throws JAXRSCommonClient.Fault {
        String cookieName = "cookieName";
        String cookieValue = "cookieValue";
        RuntimeDelegate.HeaderDelegate hdnc = this.delegate.createHeaderDelegate(NewCookie.class);
        Assertions.assertTrue((hdnc != null ? 1 : 0) != 0, (String)"HeaderDelegate<NewCookie> has not been created");
        NewCookie cookie = new NewCookie(cookieName, cookieValue);
        String result = hdnc.toString((Object)cookie);
        NewCookie serialized = (NewCookie)hdnc.fromString(result);
        Assertions.assertTrue((boolean)cookieName.equals(serialized.getName()), (String)"HeaderDelegate<NewCookie> fromString(),toString() failed");
    }

    @Test
    public void checkCreatedHeaderDelegateMediaTypeTest() throws JAXRSCommonClient.Fault {
        RuntimeDelegate.HeaderDelegate hdmt = this.delegate.createHeaderDelegate(MediaType.class);
        Assertions.assertTrue((hdmt != null ? 1 : 0) != 0, (String)"HeaderDelegate<MediaType> has not been created");
        MediaType type = new MediaType("text", "html");
        String toString = hdmt.toString((Object)type);
        MediaType serialized = (MediaType)hdmt.fromString(toString);
        Assertions.assertTrue((boolean)serialized.isCompatible(MediaType.TEXT_HTML_TYPE), (String)"HeaderDelegate<MediaType> fromString(),toString() failed");
    }

    @Test
    public void checkCreatedHeaderDelegateNullPointerTest() throws JAXRSCommonClient.Fault {
        RuntimeDelegate.HeaderDelegate hdmt = this.delegate.createHeaderDelegate(MediaType.class);
        Assertions.assertTrue((hdmt != null ? 1 : 0) != 0, (String)"HeaderDelegate<MediaType> has not been created");
        try {
            hdmt.fromString(null);
            throw new JAXRSCommonClient.Fault("HeaderDelegate.fromString(null) did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                hdmt.toString(null);
                throw new JAXRSCommonClient.Fault("HeaderDelegate.toString(null) did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return;
            }
        }
    }

    @Test
    public void createHeaderDelegateThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            this.delegate.createHeaderDelegate((Class)null);
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }
}

