/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)CtorSetGet.test.xml	1.5 07/01/24 Oleg Oleinik
 * Generated from : api/jakarta_xml/bind/helpers/ValidationEventImpl/CtorSetGet.test.xml
 *
 * Constructor, setXXX, getXXX tests
 * Constructor, getLinkedException, getLocator, getMessage, getSeverity,
 * setLinkedException, setLocator, setMessage, setSeverity tests.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.helpers.ValidationEventImpl;

import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventLocator;
import jakarta.xml.bind.helpers.ValidationEventImpl;
import java.util.Arrays;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;


public class CtorSetGetTests extends MultiTest {

    int[] valid_severity = {ValidationEvent.ERROR, ValidationEvent.FATAL_ERROR, ValidationEvent.WARNING};
    {
        Arrays.sort( valid_severity );
    }
    int[] invalid_severity = {3, -1, 65535};
    {
        for( int i = 0; i < invalid_severity.length; i++){
            while( Arrays.binarySearch( valid_severity, invalid_severity[i] ) >= 0 )
                invalid_severity[i]++;
        }
    }

    ValidationEventLocator[] valid_locator = null;
    {
        try {
            valid_locator = new ValidationEventLocator[] {new MyValidationEventLocator(new java.net.URL("http://www.sun.com"), 10, 10, 10, null, null)};
        } catch (java.net.MalformedURLException me) {
            throw new RuntimeException(me.toString());
        }
    }
    ValidationEventLocator[] invalid_locator = {null};

    Throwable[] valid_exception = {new Error("error"), new Exception("exception"),
        new RuntimeException("runtime exception"), new Throwable("throwable")};
    Throwable[] invalid_exception = {null};

    String[] valid_message = {"error"};
    String[] invalid_message = {"", null};

    /* standalone interface */
    public static void main(String argv[]) {
        CtorSetGetTests test = new CtorSetGetTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public java.lang.Throwable getLinkedException(),
     * ValidationEventImpl(int, String, ValidationEventLocator) with all arguments non-null, valid: getLinkedException() returns
     * null if the linked exception wasn't set..
     * <br><b>Expected results</b>: returns null
     */
    public Status CtorSetGet001() {
        for (int i_severity = 0; i_severity < valid_severity.length; ++i_severity){
            for (int i_message = 0; i_message < valid_message.length; ++i_message){
                for (int i_locator = 0; i_locator < valid_locator.length; ++i_locator){
                    ValidationEventImpl event = new ValidationEventImpl(valid_severity[i_severity], valid_message[i_message],
                         valid_locator[i_locator]);
                    if (event.getSeverity() != valid_severity[i_severity]){
                        return Status.failed("ValidationEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                        "\", non-null locator):  getSeverity() returns " + event.getSeverity());
                    }
                    if (!valid_message[i_message].equals(event.getMessage())){
                        return Status.failed("ValidationEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                        "\", non-null locator):  getMessage() returns " + event.getMessage());
                    }
                    ValidationEventLocator locator = event.getLocator();
                    if (locator.getOffset() != 10 || locator.getLineNumber() != 10 || locator.getColumnNumber() != 10){
                        return Status.failed("ValidationEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                        "\", non-null locator):  getLocator() returns wrong object");
                    }
                    if (event.getLinkedException() != null){
                        return Status.failed("ValidationEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                        "\", non-null locator):  getLinkedException() returns non-null value");
                    }
                }
            }
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void setSeverity(int _severity),
     * ValidationEventImpl(int, String, ValidationEventLocator) with all arguments non-null, valid: setMessage(valid_value) does not
     * cause problems..
     * <br><b>Expected results</b>: no exceptions
     */
    public Status CtorSetGet002() {
        for (int i_severity = 0; i_severity < valid_severity.length; ++i_severity){
            ValidationEventImpl event = new ValidationEventImpl(valid_severity[0], valid_message[0], valid_locator[0]);
            event.setSeverity(valid_severity[i_severity]);
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void setMessage(java.lang.String _message),
     * ValidationEventImpl(int, String, ValidationEventLocator) with all arguments non-null, valid: setMessage(valid_value)
     * does not cause problems..
     * <br><b>Expected results</b>: no exceptions
     */
    public Status CtorSetGet003() {
        for (int i_message = 0; i_message < valid_message.length; ++i_message){
            ValidationEventImpl event = new ValidationEventImpl(valid_severity[0], valid_message[0], valid_locator[0]);
            event.setMessage(valid_message[i_message]);
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void setLinkedException(java.lang.Throwable _linkedException),
     * ValidationEventImpl(int, String, ValidationEventLocator) with all arguments non-null, valid: setLinkedException(valid_value)
     * does not cause problems..
     * <br><b>Expected results</b>: no exceptions
     */
    public Status CtorSetGet004() {
        for (int i_exception = 0; i_exception < valid_exception.length; ++i_exception){
            ValidationEventImpl event = new ValidationEventImpl(valid_severity[0], valid_message[0], valid_locator[0]);
            event.setLinkedException(valid_exception[i_exception]);
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void setLocator(ValidationEventLocator _locator),
     * ValidationEventImpl(int, String, ValidationEventLocator) with all arguments non-null, valid: setLocator(valid_value)
     * does not cause problems..
     * <br><b>Expected results</b>: no exceptions
     */
    public Status CtorSetGet005() {
        for (int i_locator = 0; i_locator < valid_locator.length; ++i_locator){
            ValidationEventImpl event = new ValidationEventImpl(valid_severity[0], valid_message[0], valid_locator[0]);
            event.setLocator(valid_locator[i_locator]);
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public java.lang.Throwable getLinkedException(),
     * ValidationEventImpl(int, String, ValidationEventLocator, Throwable) with all arguments non-null, valid: getLinkedException() returns
     * the linked exception for this warning/error..
     * <br><b>Expected results</b>: returns the exception with which ValidationEventImpl object was created
     */
    public Status CtorSetGet101() {
        for (int i_severity = 0; i_severity < valid_severity.length; ++i_severity){
            for (int i_message = 0; i_message < valid_message.length; ++i_message){
                for (int i_locator = 0; i_locator < valid_locator.length; ++i_locator){
                    for (int i_exception = 0; i_exception < valid_exception.length; ++i_exception){
                        ValidationEventImpl event = new ValidationEventImpl(valid_severity[i_severity], valid_message[i_message],
                            valid_locator[i_locator], valid_exception[i_exception]);
                        if (event.getSeverity() != valid_severity[i_severity]){
                            return Status.failed("ValidationEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                            "\", non-null locator, non-null exception):  getSeverity() returns " + event.getSeverity());
                        }
                        if (!valid_message[i_message].equals(event.getMessage())){
                            return Status.failed("ValidationEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                            "\", non-null locator, non-null exception):  getMessage() returns " + event.getMessage());
                        }
                        ValidationEventLocator locator = event.getLocator();
                        if (locator.getOffset() != 10 || locator.getLineNumber() != 10 || locator.getColumnNumber() != 10){
                            return Status.failed("ValidationEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                            "\", non-null locator, non-null exception):  getLocator() returns wrong object");
                        }
                        Throwable e = event.getLinkedException();
                        if (!(valid_exception[i_exception].getClass().isInstance(e)) || !(e.getMessage().equals(valid_exception[i_exception].getMessage()))){
                            return Status.failed("ValidationEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                            "\", non-null locator, non-null exception):  getLinkedException() returns wrong value");
                        }
                    }
                }
            }
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void setSeverity(int _severity),
     * ValidationEventImpl(int, String, ValidationEventLocator, Throwable) with all arguments non-null, valid: setMessage(valid_value) does not
     * cause problems..
     * <br><b>Expected results</b>: no exceptions
     */
    public Status CtorSetGet102() {
        for (int i_severity = 0; i_severity < valid_severity.length; ++i_severity){
            ValidationEventImpl event = new ValidationEventImpl(valid_severity[0], valid_message[0], valid_locator[0], valid_exception[0]);
            event.setSeverity(valid_severity[i_severity]);
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void setMessage(java.lang.String _message),
     * ValidationEventImpl(int, String, ValidationEventLocator, Throwable) with all arguments non-null, valid: setMessage(valid_value)
     * does not cause problems..
     * <br><b>Expected results</b>: no exceptions
     */
    public Status CtorSetGet103() {
        for (int i_message = 0; i_message < valid_message.length; ++i_message){
            ValidationEventImpl event = new ValidationEventImpl(valid_severity[0], valid_message[0], valid_locator[0], valid_exception[0]);
            event.setMessage(valid_message[i_message]);
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void setLinkedException(java.lang.Throwable _linkedException),
     * ValidationEventImpl(int, String, ValidationEventLocator, Throwable) with all arguments non-null, valid: setLinkedException(valid_value)
     * does not cause problems..
     * <br><b>Expected results</b>: no exceptions
     */
    public Status CtorSetGet104() {
        for (int i_exception = 0; i_exception < valid_exception.length; ++i_exception){
            ValidationEventImpl event = new ValidationEventImpl(valid_severity[0], valid_message[0], valid_locator[0], valid_exception[0]);
            event.setLinkedException(valid_exception[i_exception]);
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void setLocator(ValidationEventLocator _locator),
     * ValidationEventImpl(int, String, ValidationEventLocator, Throwable) with all arguments non-null, valid: setLocator(valid_value)
     * does not cause problems..
     * <br><b>Expected results</b>: no exceptions
     */
    public Status CtorSetGet105() {
        for (int i_locator = 0; i_locator < valid_locator.length; ++i_locator){
            ValidationEventImpl event = new ValidationEventImpl(valid_severity[0], valid_message[0], valid_locator[0], valid_exception[0]);
            event.setLocator(valid_locator[i_locator]);
        }
        return Status.passed("OKAY");
    }

    /**
     * Functional tests for ValidationEventImpl,
     * ValidationEventImpl(int _severity, String _message, ValidationEventLocator _locator) Throws: IllegalArgumentException - if an illegal severity field is supplied.
     */
    public Status Ctor3_IAE() {
        for( int i = 0; i < invalid_severity.length; i++)
                try {
                    new ValidationEventImpl( invalid_severity[i], null, null );
                    return Status.failed( "expected IllegalArgumentException was not thrown" );
                } catch(IllegalArgumentException e) {}
            return Status.passed("OK");
            	}

    /**
     * Functional tests for ValidationEventImpl,
     * ValidationEventImpl(int _severity, String _message, ValidationEventLocator _locator, Throwable _linkedException) Throws: IllegalArgumentException - if an illegal severity field is supplied.
     */
    public Status Ctor4_IAE() {
        for( int i = 0; i < invalid_severity.length; i++)
                try {
                    new ValidationEventImpl( invalid_severity[i], null, null, null );
                    return Status.failed( "expected IllegalArgumentException was not thrown" );
                } catch(IllegalArgumentException e) {}
            return Status.passed("OK");
            	}

    /**
     * Functional tests for ValidationEventImpl,
     * setSeverity(int _severity) Throws: IllegalArgumentException - if an illegal severity field is supplied.
     */
    public Status SetSeverity_IAE() {
        for( int i = 0; i < invalid_severity.length; i++)
                try {
                    new ValidationEventImpl( valid_severity[0], null, null ).setSeverity( invalid_severity[i] );
                    return Status.failed( "expected IllegalArgumentException was not thrown" );
                } catch(IllegalArgumentException e) {}
            return Status.passed("OK");
            	}
}

    class MyValidationEventLocator implements ValidationEventLocator {
        java.net.URL url = null;
        int offset = -1;
        int lineNumber = -1;
        int columnNumber = -1;
        Object object = null;
        org.w3c.dom.Node node = null;

        public MyValidationEventLocator (java.net.URL url, int offset, int lineNumber,
                int columnNumber, Object object, org.w3c.dom.Node node){
            this.url = url;
            this.offset = offset;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            this.object = object;
            this.node = node;
        }
        public java.net.URL getURL(){
            return url;
        }
        public int getOffset(){
            return offset;
        }
        public int getLineNumber(){
            return lineNumber;
        }
        public int getColumnNumber(){
            return columnNumber;
        }
        public java.lang.Object getObject(){
            return object;
        }
        public org.w3c.dom.Node getNode(){
            return node;
        }
    }
