/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._float.maxinclusive.maxinclusive_4;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxInclusive4_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxInclusive4_GetSetCTTests test = new maxInclusive4_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    static strictfp boolean equal(float a, float b) { return a == b; };

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "maxInclusive-4-1.xml", "maxInclusive-4-2.xml", "maxInclusive-4-3.xml",
            "maxInclusive-4-4.xml", "maxInclusive-4-5.xml"
        };
        float[] expectedValues = {0.0F, 0.0F, 0.0F, 4.391583E-7F, Float.POSITIVE_INFINITY};
        float[] anExpectedValues = {0.0F, - Float.MAX_VALUE, Float.MIN_VALUE, - Float.MIN_VALUE
                                   , Float.POSITIVE_INFINITY};
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Float> elemObj = (JAXBElement<Float>)unmarshal(xmlDocNames[i]);
            if (!equal(elemObj.getValue(), expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!equal(elemObj.getValue(), anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        float[] setValues = {0.0F, 4.391583E-7F, Float.POSITIVE_INFINITY
                            , Float.MAX_VALUE, Float.MIN_VALUE};
        float[] anSetValues = {0.0F, Float.MAX_VALUE, Float.MIN_VALUE, - Float.MIN_VALUE
                              , Float.POSITIVE_INFINITY};
        JAXBElement<Float> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Float>)(new ObjectFactory()).createNISTSchemaFloatMaxInclusive4(setValues[i]);
            
            if (!equal(elemObj.getValue(), setValues[i])){
                return Status.failed("dynamically created JAXBElement<Float>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!equal(elemObj.getValue(), anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<Float>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

