/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util.sec.security.util;

import com.sun.ts.lib.util.sec.net.www.ParseUtil;
import com.sun.ts.lib.util.sec.security.util.Debug;
import com.sun.ts.lib.util.sec.security.util.Password;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.Arrays;

public class PolicyUtil {
    private static final String P11KEYSTORE = "PKCS11";
    private static final String NONE = "NONE";

    public static InputStream getInputStream(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String path = url.getFile().replace('/', File.separatorChar);
            path = ParseUtil.decode(path);
            return new FileInputStream(path);
        }
        return url.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(URL policyUrl, String keyStoreName, String keyStoreType, String keyStoreProvider, String storePassURL, Debug debug) throws KeyStoreException, MalformedURLException, IOException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore;
        block27: {
            KeyStore ks;
            char[] keyStorePassword;
            block24: {
                Object passURL;
                block25: {
                    if (keyStoreName == null) {
                        throw new IllegalArgumentException("null KeyStore name");
                    }
                    keyStorePassword = null;
                    try {
                        if (keyStoreType == null) {
                            keyStoreType = KeyStore.getDefaultType();
                        }
                        if (P11KEYSTORE.equalsIgnoreCase(keyStoreType) && !NONE.equals(keyStoreName)) {
                            throw new IllegalArgumentException("Invalid value (" + keyStoreName + ") for keystore URL.  If the keystore type is \"PKCS11\", the keystore url must be \"NONE\"");
                        }
                        ks = keyStoreProvider != null ? KeyStore.getInstance(keyStoreType, keyStoreProvider) : KeyStore.getInstance(keyStoreType);
                        if (storePassURL != null) {
                            try {
                                passURL = new URL(storePassURL);
                            }
                            catch (MalformedURLException e) {
                                if (policyUrl == null) {
                                    throw e;
                                }
                                passURL = new URL(policyUrl, storePassURL);
                            }
                            if (debug != null) {
                                debug.println("reading password" + (URL)passURL);
                            }
                            try (InputStream in = null;){
                                in = ((URL)passURL).openStream();
                                keyStorePassword = Password.readPassword(in);
                            }
                        }
                        if (!NONE.equals(keyStoreName)) break block24;
                        ks.load(null, keyStorePassword);
                        passURL = ks;
                        if (keyStorePassword == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (keyStorePassword != null) {
                            Arrays.fill(keyStorePassword, ' ');
                        }
                        throw throwable;
                    }
                    Arrays.fill(keyStorePassword, ' ');
                }
                return passURL;
            }
            URL keyStoreUrl = null;
            try {
                keyStoreUrl = new URL(keyStoreName);
            }
            catch (MalformedURLException e) {
                if (policyUrl == null) {
                    throw e;
                }
                keyStoreUrl = new URL(policyUrl, keyStoreName);
            }
            if (debug != null) {
                debug.println("reading keystore" + keyStoreUrl);
            }
            try (InputStream inStream = null;){
                inStream = new BufferedInputStream(PolicyUtil.getInputStream(keyStoreUrl));
                ks.load(inStream, keyStorePassword);
            }
            keyStore = ks;
            if (keyStorePassword == null) break block27;
            Arrays.fill(keyStorePassword, ' ');
        }
        return keyStore;
    }
}

