/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.exec.FileTableNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class FileSystemTableModel
extends AbstractTableModel {
    protected static String[] cNames = new String[]{"File Name", "Name", "Description"};
    protected static Class<?>[] cTypes = new Class[]{String.class, String.class, String.class};
    private FileTableFilter filter = null;
    private FileTableNode root;
    private ArrayList<FileTableNode> data;
    private LinkedHashMap<String, String[]> fileData;
    private boolean allowTraversDirs;
    private File defTemplateDir;

    public FileSystemTableModel(String file, FileTableFilter flt, File defTemplateDir, boolean allowTraversDirs) {
        this.setFilter(flt);
        this.allowTraversDirs = allowTraversDirs;
        this.defTemplateDir = defTemplateDir;
        this.init(file);
    }

    @Override
    public void fireTableDataChanged() {
    }

    public void resetTable(String file, FileTableFilter flt) {
        this.setFilter(flt);
        this.init(file);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void resetTable(String file) {
        this.init(file);
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return cNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return cTypes[column];
    }

    private void setFilter(FileTableFilter flt) {
        this.filter = flt;
    }

    private void init(String f) {
        File file = new File(f);
        this.init(file);
    }

    public File getCurrentDir() {
        return this.root.getFile();
    }

    private void init(File file) {
        Object[] lst;
        this.root = new FileTableNode(file, 'r');
        this.data = new ArrayList();
        if ((this.allowTraversDirs || !file.equals(this.defTemplateDir)) && file.getParent() != null) {
            this.data.add(new FileTableNode(file.getParentFile(), 'u'));
        }
        if ((lst = file.listFiles()) != null) {
            Arrays.sort(lst);
        }
        if (lst != null && lst.length > 0) {
            for (Object aLst1 : lst) {
                if (!((File)aLst1).isDirectory()) continue;
                this.data.add(new FileTableNode((File)aLst1, 'd'));
            }
            for (Object aLst : lst) {
                if (((File)aLst).isDirectory() || this.filter != null && !this.filter.isApplicableFile((File)aLst)) continue;
                this.data.add(new FileTableNode((File)aLst, 'f'));
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.data.size()) {
            return null;
        }
        FileTableNode f = this.data.get(rowIndex);
        File file = f.getFile();
        if (file == null) {
            return null;
        }
        if (columnIndex == 0) {
            return f;
        }
        if (file.isDirectory()) {
            return "";
        }
        if (columnIndex == 1) {
            return this.getConfigName(file);
        }
        if (columnIndex == 2) {
            return this.getConfigDesc(file);
        }
        return null;
    }

    public File getNode(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.data.size()) {
            return null;
        }
        return this.data.get(rowIndex).getFile();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    private String getConfigName(File file) {
        return this.getInfo(file)[0];
    }

    private String getConfigDesc(File file) {
        return this.getInfo(file)[1];
    }

    private String[] getInfo(File file) {
        String key;
        String[] value;
        if (this.fileData == null) {
            this.fileData = new LinkedHashMap<String, String[]>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, String[]> eldest) {
                    return this.size() > 500;
                }
            };
        }
        if ((value = this.fileData.get(key = file.getAbsolutePath())) != null) {
            return value;
        }
        try {
            String[] data = new String[]{"", ""};
            TemplateUtilities.ConfigInfo ci = TemplateUtilities.getConfigInfo(file);
            if (ci != null) {
                data = new String[]{ci.getName(), ci.getDescription()};
            }
            this.fileData.put(key, data);
            return data;
        }
        catch (Exception e) {
            return new String[]{"", ""};
        }
    }

    static class FileTableFilter {
        private String extension;

        FileTableFilter(String ext) {
            this.extension = ext;
        }

        protected boolean isApplicableFile(File f) {
            if (this.extension == null) {
                return true;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(this.extension);
        }
    }
}

