/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.module.soap;

import com.sun.ts.tests.jaspic.tssv.util.CommonCallbackSupport;
import com.sun.ts.tests.jaspic.tssv.util.ServerCallbackSupport;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.xml.soap.SOAPMessage;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class TSServerAuthModule
implements ServerAuthModule {
    private static TSLogger logger = null;
    private static CallbackHandler callbackHandler = null;
    private static Map options = null;

    public void initialize(MessagePolicy reqPolicy, MessagePolicy resPolicy, CallbackHandler handler, Map optns) throws AuthException {
        callbackHandler = handler;
        options = optns;
        if (options.get("TSLogger") != null) {
            logger = (TSLogger)options.get("TSLogger");
        }
    }

    public Class[] getSupportedMessageTypes() {
        this.logMsg("TSServerAuthModule.getSupportedMessageTypes called");
        Class[] classarray = new Class[]{SOAPMessage.class};
        return classarray;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Object msg = "";
        msg = clientSubject != null ? "TSServerAuthModule.validateRequest called with client Subject :" + this.getPrincipalNameFromSubject(clientSubject) : "TSClientAuthModule.validateRequest called with null client Subject";
        msg = serviceSubject != null ? (String)msg + " with serviceSubject :" + this.getPrincipalNameFromSubject(serviceSubject) : (String)msg + " with null serviceSubject";
        this.logMsg((String)msg);
        this.logMessageTypes(messageInfo, "validateRequest");
        ServerCallbackSupport serverCallbackSupport = new ServerCallbackSupport(logger, callbackHandler, "SOAP");
        serverCallbackSupport.verify();
        CommonCallbackSupport commonCallbacks = new CommonCallbackSupport(logger, callbackHandler, "SOAP", "ServerRuntime");
        commonCallbacks.verify();
        return AuthStatus.SUCCESS;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        Object msg = "";
        msg = serviceSubject != null ? "TSServerAuthModule.secureResponse called with serviceSubject :" + this.getPrincipalNameFromSubject(serviceSubject) : "TSServerAuthModule.secureResponse called with null service Subject";
        this.logMsg((String)msg);
        this.logMessageTypes(messageInfo, "secureResponse");
        return AuthStatus.SEND_SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.logMsg("TSServerAuthModule.cleanSubject called");
        subject = null;
    }

    public void logMsg(String str) {
        if (logger != null) {
            logger.log(Level.INFO, str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }

    public String getPrincipalNameFromSubject(Subject sub) {
        Principal principal2 = null;
        Object concatPrincipalName = "";
        Set<Principal> principalSet = sub.getPrincipals();
        for (Principal principal2 : principalSet) {
            concatPrincipalName = (String)concatPrincipalName + principal2.getName();
        }
        return concatPrincipalName;
    }

    private void logMessageTypes(MessageInfo messageInfo, String methodName) {
        String msg = null;
        Object requestMessage = messageInfo.getRequestMessage();
        Object responseMessage = messageInfo.getResponseMessage();
        if (requestMessage != null) {
            if (requestMessage instanceof SOAPMessage) {
                msg = methodName + " : MessageInfo.getRequestMessage() is of type jakarta.xml.soap.SOAPMessage";
                this.logMsg(msg);
            } else {
                msg = methodName + " : MessageInfo.getRequestMessage() is of type " + requestMessage.getClass().getName();
                this.logMsg(msg);
            }
        }
        if (responseMessage != null) {
            if (responseMessage instanceof SOAPMessage) {
                msg = methodName + " : MessageInfo.getResponseMessage() is of type jakarta.xml.soap.SOAPMessage";
                this.logMsg(msg);
            } else {
                msg = methodName + " : MessageInfo.getResponseMessage() is of type " + responseMessage.getClass().getName();
                this.logMsg(msg);
            }
        }
    }
}

