/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.api.exception;

import jakarta.json.bind.JsonbException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class JsonbExceptionTest {
    private static final String EXCEPTION_MESSAGE = "Exception message";

    @Test
    public void testJsonbExceptionString() {
        JsonbException jsonbException = new JsonbException(EXCEPTION_MESSAGE);
        String validationMessage = "Failed to create JsonbException with an exception message and empty cause.";
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonbException.getMessage(), (Matcher)Matchers.is((Object)EXCEPTION_MESSAGE));
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonbException.getCause(), (Matcher)Matchers.nullValue());
        RuntimeException exception = new RuntimeException();
        jsonbException.initCause(exception);
        validationMessage = "Failed to initialize the JsonbException cause with a call to initCause method.";
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonbException.getMessage(), (Matcher)Matchers.is((Object)EXCEPTION_MESSAGE));
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonbException.getCause(), (Matcher)Matchers.is((Object)exception));
    }

    @Test
    public void testJsonbExceptionStringThrowable() {
        RuntimeException cause = new RuntimeException();
        JsonbException jsonbException = new JsonbException(EXCEPTION_MESSAGE, (Throwable)cause);
        String validationMessage = "Failed to create JsonbException with an exception message and cause.";
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonbException.getMessage(), (Matcher)Matchers.is((Object)EXCEPTION_MESSAGE));
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonbException.getCause(), (Matcher)Matchers.is((Object)cause));
    }
}

