/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonarraytests;

import ee.jakarta.tck.jsonp.api.common.ArrayBuilder;
import ee.jakarta.tck.jsonp.api.common.JsonAssert;
import ee.jakarta.tck.jsonp.api.common.JsonIO;
import ee.jakarta.tck.jsonp.api.common.JsonValueType;
import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.jsonarraytests.ArrayCommon;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class ArrayBuildRemove
extends ArrayCommon {
    private static final Logger LOGGER = Logger.getLogger(ArrayBuildRemove.class.getName());

    ArrayBuildRemove() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonArrayBuilder API remove() methods added in JSON-P 1.1.");
        LOGGER.info("JsonArrayBuilder API remove() methods added in JSON-P 1.1.");
        this.testRemove(result);
        this.testRemoveOutOfBounds(result);
        return result;
    }

    private void testRemove(TestResult result) {
        Object[] values;
        for (Object value : values = new Object[]{SimpleValues.OBJ_VALUE, "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true}) {
            String typeName = JsonValueType.getType(value).name();
            LOGGER.info(" - remove(int," + typeName + ")");
            String json = "[]";
            JsonValue check = JsonIO.read("[]");
            JsonArrayBuilder builder = ArrayBuilder.add(Json.createArrayBuilder(), value);
            builder = this.updateOperationBuilder(builder, 0, null);
            JsonArray out = builder.build();
            if (!this.operationFailed(check, (JsonValue)out)) continue;
            result.fail("remove(" + typeName + ")", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    private void testRemoveOutOfBounds(TestResult result) {
        Object[] values = new Object[]{SimpleValues.OBJ_VALUE, "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true};
        int[] indexes = new int[]{-1, 2, 3};
        for (Object value : values) {
            String typeName = JsonValueType.getType(value).name();
            LOGGER.info(" - remove(int," + typeName + ")");
            String json = "[" + JsonValueType.toStringValue(value) + "]";
            JsonArrayBuilder builder = ArrayBuilder.add(Json.createArrayBuilder(), value);
            for (int index : indexes) {
                try {
                    builder = this.updateOperationBuilder(builder, index, null);
                    result.fail("remove(int," + typeName + ")", "Calling method with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException");
                }
                catch (IndexOutOfBoundsException e) {
                    LOGGER.info("    - Expected exception for index=" + index + ": " + e.getMessage());
                }
                catch (Throwable t) {
                    result.fail("remove(int,(" + typeName + ")null)", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
                }
            }
        }
    }

    @Override
    protected JsonArrayBuilder createArrayBuilder(Object value) {
        throw new UnsupportedOperationException("Method remove is not implemented.");
    }

    @Override
    protected JsonArrayBuilder createArrayBuilder(int index, Object value) {
        throw new UnsupportedOperationException("Method remove is not implemented.");
    }

    @Override
    protected JsonArrayBuilder updateOperationBuilder(JsonArrayBuilder builder, Object value) {
        throw new UnsupportedOperationException("Method remove is not implemented.");
    }

    @Override
    protected JsonArrayBuilder updateOperationBuilder(JsonArrayBuilder builder, int index, Object value) {
        return ArrayBuilder.remove(builder, index);
    }
}

