/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.mergetests;

import ee.jakarta.tck.jsonp.api.common.MergeRFCObject;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.mergetests.MergeCommon;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class MergeRFCSample
extends MergeCommon {
    private static final Logger LOGGER = Logger.getLogger(MergeRFCSample.class.getName());

    MergeRFCSample() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 7396: Example JSON object");
        LOGGER.info("Testing RFC 7396: Example JSON object");
        this.testMerge(result);
        this.testDiff(result);
        return result;
    }

    private void testMerge(TestResult result) {
        LOGGER.info(" - merge");
        JsonObject in = MergeRFCObject.createRFCSourceObject();
        JsonObject patch = MergeRFCObject.createRFCPatchObject();
        JsonObject check = MergeRFCObject.createRFCTargetObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testDiff(TestResult result) {
        LOGGER.info(" - diff");
        JsonObject in = MergeRFCObject.createRFCSourceObject();
        JsonObject diff = MergeRFCObject.createRFCPatchObject();
        JsonObject out = MergeRFCObject.createRFCTargetObject();
        this.simpleDiff(result, (JsonValue)in, (JsonValue)out, (JsonValue)diff);
    }
}

