/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.util;

public final class OptionInfo {
    public static final boolean DEFAULT_SENSITIVITY = false;
    public static final int UNLIMITED = Integer.MAX_VALUE;
    private boolean required;
    private int minCount;
    private int maxCount;
    private boolean multiple;
    private boolean caseSensitive;

    public static OptionInfo requiredOption(int paramCount) {
        return new OptionInfo(true, paramCount, paramCount, false, false);
    }

    public static OptionInfo option(int paramCount) {
        return new OptionInfo(false, paramCount, paramCount, false, false);
    }

    public static OptionInfo requiredOptionVariableParams(int min, int max) {
        return new OptionInfo(true, min, max, true, false);
    }

    public static OptionInfo optionVariableParams(int min, int max) {
        return new OptionInfo(false, min, max, true, false);
    }

    public static OptionInfo optionalFlag() {
        return new OptionInfo(false, 0, 0, false, false);
    }

    public OptionInfo(boolean required, int minCount, int maxCount, boolean multiple, boolean isCaseSensitive) {
        this.required = required;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.multiple = multiple;
        this.caseSensitive = isCaseSensitive;
    }

    public String toKey(String arg) {
        String temp = arg;
        if (!this.caseSensitive) {
            temp = temp.toLowerCase();
        }
        return temp;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public boolean isCaseSentitive() {
        return this.caseSensitive;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isRequired() {
        return this.required;
    }
}

