/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.WorkDirChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.filechooser.FileFilter;

class OptionsDialog
extends ToolDialog {
    static final String OK = "OK";
    private Tool tool;
    private ActionListener okListener;
    private JPanel body;
    private JComboBox<String> tsField;
    private JButton tsBtn;
    private TestSuiteChooser testSuiteChooser;
    private JComboBox<String> wdField;
    private JButton wdBtn;
    private WorkDirChooser workDirChooser;
    private JComboBox<String> cfField;
    private JButton cfBtn;
    private JFileChooser configFileChooser;
    private Listener listener;

    OptionsDialog(Tool tool, ActionListener okListener, UIFactory uif) {
        super(tool, uif, "opts");
        this.tool = tool;
        this.okListener = okListener;
        this.setHelp("audit.options.csh");
    }

    void setParameters(InterviewParameters params) {
        if (this.body == null) {
            this.initGUI();
        }
        if (params != null) {
            File cf;
            WorkDirectory wd;
            TestSuite ts = params.getTestSuite();
            if (ts != null) {
                this.tsField.setSelectedItem(ts.getPath());
            }
            if ((wd = params.getWorkDirectory()) != null) {
                this.wdField.setSelectedItem(wd.getPath());
            }
            if ((cf = params.getFile()) != null) {
                this.cfField.setSelectedItem(cf.getPath());
            }
        }
    }

    String getTestSuitePath() {
        return (String)this.tsField.getSelectedItem();
    }

    String getWorkDirPath() {
        return (String)this.wdField.getSelectedItem();
    }

    String getConfigFilePath() {
        return (String)this.cfField.getSelectedItem();
    }

    @Override
    protected void initGUI() {
        this.setI18NTitle("opts.title");
        this.listener = new Listener();
        this.body = this.uif.createPanel("opts.fields", new GridBagLayout(), false);
        this.body.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 13;
        lc.insets.right = 10;
        GridBagConstraints fc = new GridBagConstraints();
        fc.fill = 2;
        fc.weightx = 1.0;
        GridBagConstraints bc = new GridBagConstraints();
        bc.gridwidth = 0;
        bc.fill = 3;
        CompoundBorder smallBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 3, 0, 3));
        JLabel tsLabel = this.uif.createLabel("opts.ts", true);
        this.body.add((Component)tsLabel, lc);
        this.tsField = this.uif.createChoice("opts.ts", true, tsLabel);
        this.tsField.addItem("");
        this.tsField.addActionListener(this.listener);
        this.body.add(this.tsField, fc);
        this.tsBtn = this.uif.createIconButton("opts.ts.browse", this.listener);
        this.tsBtn.setBorder(smallBorder);
        this.body.add((Component)this.tsBtn, bc);
        JLabel wdLabel = this.uif.createLabel("opts.wd", true);
        this.body.add((Component)wdLabel, lc);
        this.wdField = this.uif.createChoice("opts.wd", true, wdLabel);
        this.wdField.addItem("");
        this.wdField.addActionListener(this.listener);
        this.body.add(this.wdField, fc);
        this.wdBtn = this.uif.createIconButton("opts.wd.browse", this.listener);
        this.wdBtn.setBorder(smallBorder);
        this.body.add((Component)this.wdBtn, bc);
        JLabel cfLabel = this.uif.createLabel("opts.config", true);
        this.body.add((Component)cfLabel, lc);
        this.cfField = this.uif.createChoice("opts.config", true, cfLabel);
        this.cfField.addItem("");
        this.cfField.setEditable(true);
        this.cfField.addActionListener(this.listener);
        this.body.add(this.cfField, fc);
        this.cfBtn = this.uif.createIconButton("opts.config.browse", this.listener);
        this.cfBtn.setBorder(smallBorder);
        this.body.add((Component)this.cfBtn, bc);
        Dimension d = this.body.getPreferredSize();
        int dpi = this.uif.getDotsPerInch();
        this.body.setPreferredSize(new Dimension(Math.max(d.width, 5 * dpi), d.height));
        this.setBody(this.body);
        JButton okBtn = this.uif.createButton("opts.ok", this.okListener, OK);
        JButton cancelBtn = this.uif.createCancelButton("opts.cancel");
        JButton helpBtn = this.uif.createHelpButton("opts.help", "audit.options.csh");
        this.setButtons(new JButton[]{okBtn, cancelBtn, helpBtn}, okBtn);
        this.setComponentListener(this.listener);
    }

    private void updateFieldChoices() {
        this.updateTestSuiteChoices();
        this.updateWorkDirectoryChoices();
        this.updateConfigFileChoices();
    }

    private void chooseTestSuite() {
        int action;
        if (this.testSuiteChooser == null) {
            this.testSuiteChooser = new TestSuiteChooser();
        }
        if ((action = this.testSuiteChooser.showDialog(this.tool)) != 0) {
            return;
        }
        TestSuite ts = this.testSuiteChooser.getSelectedTestSuite();
        this.tsField.setSelectedItem(ts.getPath());
    }

    private void updateTestSuiteChoices() {
        TreeSet<String> s = new TreeSet<String>();
        Desktop d = this.tool.getDesktop();
        Tool[] tools = d.getTools();
        if (tools != null) {
            for (Tool t : tools) {
                TestSuite[] tss = t.getLoadedTestSuites();
                if (tss == null) continue;
                for (TestSuite ts : tss) {
                    s.add(ts.getPath());
                }
            }
        }
        this.setItems(this.tsField, s);
        this.updateWorkDirectoryChoices();
    }

    private void chooseWorkDirectory() {
        int action;
        if (this.workDirChooser == null) {
            this.workDirChooser = new WorkDirChooser(true);
            this.workDirChooser.setMode(1);
        }
        if ((action = this.workDirChooser.showDialog(this.tool)) != 0) {
            return;
        }
        WorkDirectory wd = this.workDirChooser.getSelectedWorkDirectory();
        this.wdField.setSelectedItem(wd.getPath());
    }

    private void updateWorkDirectoryChoices() {
        String tsID = null;
        try {
            String tsp = (String)this.tsField.getSelectedItem();
            if (tsp != null && !tsp.isEmpty()) {
                TestSuite ts = TestSuite.open(new File(tsp));
                tsID = ts.getID();
            }
        }
        catch (Exception tsp) {
            // empty catch block
        }
        TreeSet<String> s = new TreeSet<String>();
        Desktop d = this.tool.getDesktop();
        Tool[] tools = d.getTools();
        if (tools != null) {
            for (Tool t : tools) {
                WorkDirectory[] wds = t.getLoadedWorkDirectories();
                if (wds == null) continue;
                for (WorkDirectory wd : wds) {
                    if (tsID != null && !tsID.equals(wd.getTestSuite().getID())) continue;
                    s.add(wd.getPath());
                }
            }
        }
        this.setItems(this.wdField, s);
    }

    private void chooseConfigFile() {
        String cfp;
        int action;
        if (this.configFileChooser == null) {
            this.configFileChooser = new JFileChooser();
            String userDir = System.getProperty("user.dir");
            if (userDir != null) {
                this.configFileChooser.setCurrentDirectory(new File(userDir));
            }
            this.configFileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getPath().endsWith(".jti");
                }

                @Override
                public String getDescription() {
                    return OptionsDialog.this.uif.getI18NString("opts.jtiFiles");
                }
            });
        }
        if ((action = this.configFileChooser.showOpenDialog(this.tool)) != 0) {
            return;
        }
        File cf = this.configFileChooser.getSelectedFile();
        if (cf == null) {
            cfp = "";
        } else {
            cfp = cf.getPath();
            if (!cfp.endsWith(".jti")) {
                cfp = cfp + ".jti";
            }
        }
        this.cfField.setSelectedItem(cfp);
    }

    private void updateConfigFileChoices() {
        TreeSet<String> s = new TreeSet<String>();
        String wdp = (String)this.wdField.getSelectedItem();
        try {
            File[] entries;
            WorkDirectory wd = WorkDirectory.open(new File(wdp));
            FileHistory history = FileHistory.getFileHistory(wd, "configHistory.jtl");
            for (File entry : entries = history.getRecentEntries(10)) {
                s.add(entry.getPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setItems(this.cfField, s);
    }

    private void setItems(JComboBox<String> field, SortedSet<String> s) {
        for (int i = field.getItemCount() - 1; i >= 0; --i) {
            String item = field.getItemAt(i);
            if (s.contains(item)) {
                s.remove(item);
                continue;
            }
            if (item.isEmpty() || item.equals(field.getSelectedItem())) continue;
            field.removeItemAt(i);
        }
        for (String value : s) {
            field.addItem(value);
        }
    }

    private class Listener
    extends ComponentAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            OptionsDialog.this.updateFieldChoices();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == OptionsDialog.this.tsField) {
                OptionsDialog.this.updateWorkDirectoryChoices();
            } else if (src == OptionsDialog.this.tsBtn) {
                OptionsDialog.this.chooseTestSuite();
            } else if (src == OptionsDialog.this.wdField) {
                OptionsDialog.this.updateConfigFileChoices();
            } else if (src == OptionsDialog.this.wdBtn) {
                OptionsDialog.this.chooseWorkDirectory();
            } else if (src == OptionsDialog.this.cfBtn) {
                OptionsDialog.this.chooseConfigFile();
            }
        }
    }
}

