/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.WorkDirectory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class TemplateUtilities {
    private static final String TRUE = "true";
    private static final String TEMPLATE_PREF = "TEMPLATE.";
    private static final String TEMPLATE_FILE = "template.data";
    private static final String TEMPL_FILE_PROP = "file";

    public static File getTemplateFile(WorkDirectory wd) {
        String s = TemplateUtilities.getTemplatePath(wd);
        if (s != null) {
            return new File(s);
        }
        return null;
    }

    public static String getTemplatePath(WorkDirectory wd) {
        if (wd == null) {
            return null;
        }
        File dataFile = wd.getSystemFile(TEMPLATE_FILE);
        Properties p = new Properties();
        try (FileInputStream in = new FileInputStream(dataFile);){
            p.load(in);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (p != null) {
            return p.getProperty(TEMPL_FILE_PROP);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTemplateFile(WorkDirectory wd, File t, boolean changeable) throws IOException {
        if (t == null) {
            return;
        }
        File dataFile = wd.getSystemFile(TEMPLATE_FILE);
        Properties p = new Properties();
        p.put(TEMPL_FILE_PROP, t.getCanonicalPath());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dataFile);
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            p.save(out, "template information file - do not modify");
        }
        finally {
            out.close();
        }
    }

    public static String getTemplateFromWd(File dir) throws IOException {
        File f = new File(dir, "jtData" + File.separator + TEMPLATE_FILE);
        if (!f.exists()) {
            return null;
        }
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(f);
        p.load(in);
        ((InputStream)in).close();
        return p.getProperty(TEMPL_FILE_PROP);
    }

    public static boolean isTemplate(File f) throws IOException {
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(f);
        p.load(in);
        ((InputStream)in).close();
        return Boolean.valueOf(p.getProperty("IS_TEMPLATE"));
    }

    public static ConfigInfo getConfigInfo(File f) throws IOException {
        return new ConfigInfo(f);
    }

    public static class ConfigInfo {
        String name;
        String description;
        boolean isTemplate;
        String templateUrl;

        ConfigInfo(File f) throws IOException {
            Properties p = new Properties();
            p.load(new FileInputStream(f));
            this.name = p.getProperty("NAME");
            this.description = p.getProperty("DESCRIPTION");
            this.isTemplate = Boolean.valueOf(p.getProperty("IS_TEMPLATE"));
            this.templateUrl = p.getProperty("TEMPLATE_PATH");
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isTemplate() {
            return this.isTemplate;
        }

        public String getTemplatePath() {
            return this.templateUrl;
        }
    }
}

