/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InitialUrlFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.ConfigurableTestFilter;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.tool.TestTreeSelectionPane;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.StringArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

class BasicCustomTestFilter
extends ConfigurableTestFilter {
    private static final String ALL_OF = "allOf";
    private static final String ANY_OF = "anyOf";
    private static final String EXPR = "expr";
    private static int instanceCount;
    private static int NUM_FILTERS;
    private static int KEY_FILTER;
    private static int URL_FILTER;
    private static int JTX_FILTER;
    private static int STATUS_FILTER;
    private static int TSS_FILTER;
    private static String NAME;
    private static String REASON;
    private static String DESCRIPTION;
    private final UIFactory uif;
    private ObservableTestFilter.Observer[] obs = new ObservableTestFilter.Observer[0];
    private TestResultTable lastTrt;
    private InterviewObserver intObs;
    private SettingsSnapshot activeSettings;
    private TestFilter[] activeFilters;
    private KeywordsFilter keyFilter;
    private InitialUrlFilter urlFilter;
    private TestFilter jtxFilter;
    private StatusFilter statusFilter;
    private TestFilter tsfFilter;
    private JTabbedPane editorPane;
    private boolean statusFilterNeedsUpdate;
    private ButtonGroup keyBtnGrp;
    private JRadioButton keyAllBtn;
    private JRadioButton keyMatchBtn;
    private JComboBox<String> keywordsChoice;
    private JTextField keywordsField;
    private ButtonGroup statusBtnGrp;
    private JRadioButton statusAllBtn;
    private JRadioButton statusAnyOfBtn;
    private JCheckBox[] statusChecks = new JCheckBox[4];
    private ButtonGroup testsBtnGrp;
    private TestTreeSelectionPane testsField;
    private JCheckBox jtxCheckBox;
    private JCheckBox tsfCheckBox;
    private JTextField jtxMode;
    private JList<?> jtxFileList;
    private DefaultListModel<String> jtxFiles;

    BasicCustomTestFilter(String name, ExecModel e, UIFactory uif) {
        super(name, e);
        this.uif = uif;
        this.init(null);
    }

    BasicCustomTestFilter(Map<String, String> map, ExecModel e, UIFactory uif) {
        super(map, e);
        this.uif = uif;
        this.init(map);
    }

    BasicCustomTestFilter(ExecModel e, UIFactory uif) {
        super(uif.getI18NString("basicTf.namePrefix"), e);
        this.uif = uif;
        this.init(null);
    }

    private static String kwModeToType(String mode) {
        if (Objects.equals(mode, ALL_OF)) {
            return "all of";
        }
        if (Objects.equals(mode, ANY_OF)) {
            return "any of";
        }
        return EXPR;
    }

    @Override
    ConfigurableTestFilter cloneInstance() {
        return new BasicCustomTestFilter(this.uif.getI18NString("basicTf.namePrefix") + instanceCount, this.execModel, this.uif);
    }

    @Override
    public void addObserver(ObservableTestFilter.Observer o) {
        this.obs = DynamicArray.append(this.obs, o);
    }

    @Override
    public void removeObserver(ObservableTestFilter.Observer o) {
        this.obs = DynamicArray.remove(this.obs, o);
    }

    @Override
    protected void notifyUpdated(ObservableTestFilter filter) {
        if (this.obs == null) {
            return;
        }
        for (ObservableTestFilter.Observer ob : this.obs) {
            ob.filterUpdated(filter);
        }
    }

    @Override
    boolean load(Map<String, String> map) {
        boolean result = super.load(map);
        this.activeSettings = new SettingsSnapshot(map);
        this.putSettings(this.activeSettings);
        this.activateSettings(this.activeSettings);
        this.notifyUpdated(this);
        return result;
    }

    @Override
    boolean save(Map<String, String> map) {
        boolean result = super.save(map);
        this.activeSettings.save(map);
        return result;
    }

    void update(InterviewParameters ip) {
        this.activateSettings(this.activeSettings);
    }

    @Override
    synchronized JComponent getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = this.uif.createTabbedPane("basicTf.tabs", this.createTabPanels());
            this.editorPane.setTabPlacement(1);
            try {
                if (this.activeSettings == null) {
                    this.activeSettings = this.grabSettings();
                } else {
                    this.putSettings(this.activeSettings);
                }
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Illegal state of BCTF GUI on startup.");
            }
            this.editorPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        return this.editorPane;
    }

    @Override
    String commitEditorSettings() {
        SettingsSnapshot nowSettings = null;
        try {
            nowSettings = this.grabSettings();
        }
        catch (IllegalStateException e) {
            return e.getMessage();
        }
        if (!this.activeSettings.equals(nowSettings)) {
            return this.activateSettings(nowSettings);
        }
        return null;
    }

    @Override
    void resetEditorSettings() {
        this.putSettings(this.activeSettings);
    }

    @Override
    boolean isEditorChanged() {
        SettingsSnapshot nowSettings = null;
        try {
            nowSettings = this.grabSettings();
        }
        catch (IllegalStateException e) {
            return true;
        }
        return !this.activeSettings.equals(nowSettings);
    }

    @Override
    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        return this.accepts(td, null);
    }

    @Override
    public boolean accepts(TestDescription td, TestFilter.Observer o) throws TestFilter.Fault {
        if (this.statusFilterNeedsUpdate) {
            this.updateStatusFilter();
        }
        for (TestFilter activeFilter : this.activeFilters) {
            if (activeFilter == null || activeFilter.accepts(td)) continue;
            if (o != null) {
                o.rejected(td, activeFilter);
            }
            return false;
        }
        return true;
    }

    @Override
    public String getBaseName() {
        return NAME;
    }

    @Override
    public String getName() {
        return this.instanceName;
    }

    @Override
    public String getReason() {
        return REASON;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    private void init(Map<String, String> map) {
        if (NAME == null) {
            NAME = this.uif.getI18NString("basicTf.name");
        }
        if (REASON == null) {
            REASON = this.uif.getI18NString("basicTf.reason");
        }
        if (DESCRIPTION == null) {
            DESCRIPTION = this.uif.getI18NString("basicTf.description");
        }
        this.activeSettings = map != null ? new SettingsSnapshot(map) : new SettingsSnapshot();
        ++instanceCount;
        this.observers = null;
        this.activateSettings(this.activeSettings);
    }

    private String activateSettings(SettingsSnapshot nowSettings) {
        KeywordsFilter newKeyFilter = null;
        InitialUrlFilter newUrlFilter = null;
        TestFilter newJtxFilter = null;
        StatusFilter newStatusFilter = null;
        TestFilter newTsfFilter = null;
        InterviewParameters ip = this.execModel.getInterviewParameters();
        TestSuite ts = this.execModel.getTestSuite();
        this.updateInterviewObserver(ip);
        if (nowSettings.urlsEnabled && nowSettings.initialUrls != null) {
            newUrlFilter = new InitialUrlFilter(nowSettings.initialUrls);
        }
        if (nowSettings.keywordsEnabled) {
            try {
                String[] validKeywords = ts.getKeywords();
                HashSet<String> validKeywordsSet = validKeywords == null ? null : new HashSet<String>(Arrays.asList(validKeywords));
                Keywords kw = Keywords.create(BasicCustomTestFilter.kwModeToType(nowSettings.keyChoice), nowSettings.keyString, validKeywordsSet);
                newKeyFilter = new KeywordsFilter(kw);
            }
            catch (Keywords.Fault f) {
                return f.getMessage();
            }
        }
        if (nowSettings.statusEnabled) {
            TestResultTable trt = this.execModel.getActiveTestResultTable();
            if (trt != null) {
                newStatusFilter = new StatusFilter(nowSettings.statusFields, trt);
                this.statusFilterNeedsUpdate = false;
            } else {
                this.statusFilterNeedsUpdate = true;
            }
        } else {
            this.statusFilterNeedsUpdate = false;
        }
        if (nowSettings.jtxEnabled && ip != null) {
            newJtxFilter = ip.getExcludeListFilter();
        }
        if (nowSettings.tsfEnabled && ip != null && ts != null) {
            newTsfFilter = ts.createTestFilter(ip.getEnv());
        }
        this.keyFilter = newKeyFilter;
        this.urlFilter = newUrlFilter;
        this.jtxFilter = newJtxFilter;
        this.statusFilter = newStatusFilter;
        this.tsfFilter = newTsfFilter;
        if (this.activeFilters == null) {
            this.activeFilters = new TestFilter[NUM_FILTERS];
        }
        this.activeFilters[BasicCustomTestFilter.KEY_FILTER] = this.keyFilter;
        this.activeFilters[BasicCustomTestFilter.URL_FILTER] = this.urlFilter;
        this.activeFilters[BasicCustomTestFilter.JTX_FILTER] = this.jtxFilter;
        this.activeFilters[BasicCustomTestFilter.STATUS_FILTER] = this.statusFilter;
        this.activeFilters[BasicCustomTestFilter.TSS_FILTER] = this.tsfFilter;
        this.activeSettings = nowSettings;
        this.updateExcludeInfo();
        this.notifyUpdated(this);
        return null;
    }

    private void updateStatusFilter() {
        if (!this.statusFilterNeedsUpdate) {
            return;
        }
        TestResultTable trt = this.execModel.getActiveTestResultTable();
        if (trt != null) {
            this.activeFilters[BasicCustomTestFilter.STATUS_FILTER] = new StatusFilter(this.activeSettings.statusFields, trt);
            this.statusFilterNeedsUpdate = false;
        }
    }

    private void updateInterviewObserver(InterviewParameters ip) {
        if (ip == null && this.intObs != null) {
            this.intObs.getInterview().removeObserver(this.intObs);
        } else if (this.intObs == null || this.intObs.getInterview() != ip) {
            if (this.intObs != null) {
                this.intObs.getInterview().removeObserver(this.intObs);
            }
            if (ip != null) {
                this.intObs = new InterviewObserver(ip);
                ip.addObserver(this.intObs);
            }
        }
    }

    private void updateExcludeInfo() {
        if (this.jtxMode == null) {
            return;
        }
        InterviewParameters ip = this.execModel.getInterviewParameters();
        if (ip == null) {
            return;
        }
        boolean isUnknown = true;
        Parameters.ExcludeListParameters elp = ip.getExcludeListParameters();
        if (ip != null && (elp = ip.getExcludeListParameters()) instanceof Parameters.MutableExcludeListParameters) {
            Parameters.MutableExcludeListParameters melp = (Parameters.MutableExcludeListParameters)elp;
            int mode = melp.getExcludeMode();
            switch (mode) {
                case 1: {
                    this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.none"));
                    this.setExcludeFiles(null);
                    isUnknown = false;
                    break;
                }
                case 2: {
                    this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.initial"));
                    this.setExcludeFiles(melp.getExcludeFiles());
                    isUnknown = false;
                    break;
                }
                case 3: {
                    this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.latest"));
                    this.setExcludeFiles(null);
                    isUnknown = false;
                    break;
                }
                case 4: {
                    this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.custom"));
                    this.setExcludeFiles(melp.getCustomExcludeFiles());
                    isUnknown = false;
                }
            }
        }
        if (isUnknown) {
            this.jtxMode.setText(this.uif.getI18NString("basicTf.exclude.mode.unknown"));
            this.jtxFiles.removeAllElements();
        }
    }

    private void setExcludeFiles(File ... files) {
        this.jtxFiles.removeAllElements();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            this.jtxFiles.addElement(file.getPath());
        }
    }

    private JComponent[] createTabPanels() {
        return new JComponent[]{this.createTestsPanel(), this.createKeywordPanel(), this.createStatusPanel(), this.createExcludePanel(), this.createSpecialPanel()};
    }

    private JComponent createKeywordPanel() {
        JPanel p = this.uif.createPanel("basicTf.keywords.mainPanel", new GridBagLayout(), false);
        p.setName("keywords");
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.keyBtnGrp = new ButtonGroup();
        this.keyAllBtn = this.uif.createRadioButton("basicTf.keywords.all", this.keyBtnGrp);
        this.keyAllBtn.setMnemonic(this.uif.getI18NString("basicTf.keywords.all.mne").charAt(0));
        p.add((Component)this.keyAllBtn, c);
        this.keyMatchBtn = this.uif.createRadioButton("basicTf.keywords.match", this.keyBtnGrp);
        this.keyMatchBtn.setMnemonic(this.uif.getI18NString("basicTf.keywords.match.mne").charAt(0));
        this.keyMatchBtn.addChangeListener(e -> this.enableKeywordFields());
        c.weightx = 0.0;
        c.gridwidth = 1;
        p.add((Component)this.keyMatchBtn, c);
        String[] kc = new String[]{ANY_OF, ALL_OF, EXPR};
        this.keywordsChoice = this.uif.createChoice("basicTf.keywords.choice", kc);
        p.add(this.keywordsChoice, c);
        this.keywordsField = this.uif.createInputField("basicTf.keywords.field", 20);
        this.keywordsField.setEditable(true);
        this.uif.setAccessibleInfo(this.keywordsField, "basicTf.keywords.field");
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        p.add((Component)this.keywordsField, c);
        this.keyAllBtn.setSelected(true);
        this.enableKeywordFields();
        return p;
    }

    private void enableKeywordFields() {
        boolean b = this.keyMatchBtn.isSelected();
        this.keywordsChoice.setEnabled(b);
        this.keywordsField.setEnabled(b);
    }

    private JComponent createStatusPanel() {
        JPanel p = this.uif.createPanel("basicTf.status.mainPanel", new GridBagLayout(), false);
        p.setName("status");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridwidth = 0;
        this.statusBtnGrp = new ButtonGroup();
        this.statusAllBtn = this.uif.createRadioButton("basicTf.status.all", this.statusBtnGrp);
        this.statusAllBtn.setMnemonic(this.uif.getI18NString("basicTf.status.all.mne").charAt(0));
        p.add((Component)this.statusAllBtn, c);
        this.statusAnyOfBtn = this.uif.createRadioButton("basicTf.status.anyOf", this.statusBtnGrp);
        this.statusAnyOfBtn.setMnemonic(this.uif.getI18NString("basicTf.status.anyOf.mne").charAt(0));
        this.statusAnyOfBtn.addChangeListener(e -> this.enableStatusFields());
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)this.statusAnyOfBtn, c);
        JPanel row = new JPanel(new GridBagLayout());
        row.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints rc = new GridBagConstraints();
        rc.insets.left = 10;
        this.statusChecks[0] = this.uif.createCheckBox("basicTf.status.prev.passed", false);
        row.add((Component)this.statusChecks[0], rc);
        this.statusChecks[1] = this.uif.createCheckBox("basicTf.status.prev.failed", true);
        row.add((Component)this.statusChecks[1], rc);
        this.statusChecks[2] = this.uif.createCheckBox("basicTf.status.prev.error", true);
        row.add((Component)this.statusChecks[2], rc);
        rc.insets.right = 10;
        this.statusChecks[3] = this.uif.createCheckBox("basicTf.status.prev.notRun", true);
        row.add((Component)this.statusChecks[3], rc);
        this.uif.setToolTip(row, "basicTf.status.prev");
        this.statusAllBtn.setSelected(true);
        this.enableStatusFields();
        p.add((Component)row, c);
        return p;
    }

    private void enableStatusFields() {
        boolean enable = this.statusAnyOfBtn.isEnabled() && this.statusAnyOfBtn.isSelected();
        for (JCheckBox statusCheck : this.statusChecks) {
            statusCheck.setEnabled(enable);
        }
    }

    private JComponent createTestsPanel() {
        final JPanel p = this.uif.createPanel("basicTf.tests.mainPanel", new BorderLayout(), false);
        p.setName("tests");
        this.lastTrt = this.execModel.getActiveTestResultTable();
        this.testsField = new TestTreeSelectionPane(this.lastTrt);
        p.add((Component)this.testsField, "Center");
        p.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                TestResultTable nowTrt = BasicCustomTestFilter.this.execModel.getActiveTestResultTable();
                if (nowTrt != BasicCustomTestFilter.this.lastTrt) {
                    TestTreeSelectionPane newTree = new TestTreeSelectionPane(nowTrt);
                    String[] paths = BasicCustomTestFilter.this.testsField.getSelection();
                    p.remove(BasicCustomTestFilter.this.testsField);
                    BasicCustomTestFilter.this.testsField = newTree;
                    BasicCustomTestFilter.this.testsField.setSelection(paths);
                    p.add((Component)BasicCustomTestFilter.this.testsField, "Center");
                    BasicCustomTestFilter.this.lastTrt = nowTrt;
                }
            }
        });
        return p;
    }

    private JComponent createExcludePanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setName("exclude");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.ipadx = 10;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.gridwidth = 3;
        this.jtxCheckBox = this.uif.createCheckBox("basicTf.exclude", false);
        this.jtxCheckBox.setMnemonic(this.uif.getI18NString("basicTf.exclude.mne").charAt(0));
        p.add((Component)this.jtxCheckBox, c);
        c.gridy = 1;
        p.add(Box.createVerticalStrut(5), c);
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 2;
        p.add(Box.createHorizontalStrut(8), c);
        c.gridheight = 1;
        c.gridx = 2;
        JLabel modeLab = this.uif.createLabel("basicTf.exclude.mode");
        modeLab.setDisplayedMnemonic(this.uif.getI18NString("basicTf.exclude.mode.mne").charAt(0));
        modeLab.setEnabled(this.jtxCheckBox.isSelected());
        p.add((Component)modeLab, c);
        c.gridy = 3;
        JLabel fileLab = this.uif.createLabel("basicTf.exclude.file");
        fileLab.setDisplayedMnemonic(this.uif.getI18NString("basicTf.exclude.file.mne").charAt(0));
        fileLab.setEnabled(this.jtxCheckBox.isSelected());
        p.add((Component)fileLab, c);
        c.gridy = 2;
        c.gridx = 3;
        c.fill = 2;
        this.jtxMode = this.uif.createOutputField("basicTf.exclude.mode", modeLab);
        this.jtxMode.setBorder(BorderFactory.createEmptyBorder());
        this.jtxMode.setEditable(false);
        this.jtxMode.setEnabled(this.jtxCheckBox.isSelected());
        this.uif.setAccessibleInfo(this.jtxMode, "basicTf.exclude.mode");
        p.add((Component)this.jtxMode, c);
        c.gridy = 3;
        c.weightx = 2.0;
        c.weighty = 2.0;
        c.fill = 1;
        this.jtxFiles = new DefaultListModel();
        this.jtxFileList = this.uif.createList("basicTf.exclude.file", this.jtxFiles);
        this.jtxFileList.setEnabled(this.jtxCheckBox.isSelected());
        this.uif.setAccessibleInfo(this.jtxFileList, "basicTf.exclude.file");
        fileLab.setLabelFor(this.jtxFileList);
        p.add((Component)this.uif.createScrollPane(this.jtxFileList, 20, 30), c);
        this.jtxCheckBox.addActionListener(e -> {
            this.jtxFileList.setEnabled(this.jtxCheckBox.isSelected());
            this.jtxMode.setEnabled(this.jtxCheckBox.isSelected());
            modeLab.setEnabled(this.jtxCheckBox.isSelected());
            fileLab.setEnabled(this.jtxCheckBox.isSelected());
        });
        return p;
    }

    private JComponent createSpecialPanel() {
        String k = "basicTf.tsf";
        JPanel p = this.uif.createPanel("basicTf.tsf", new BorderLayout(), false);
        p.setName("special");
        this.tsfCheckBox = this.uif.createCheckBox("basicTf.tsf", false);
        this.tsfCheckBox.setMnemonic(this.uif.getI18NString("basicTf.tsf.mne").charAt(0));
        p.add((Component)this.tsfCheckBox, "Center");
        return p;
    }

    private SettingsSnapshot grabSettings() {
        SettingsSnapshot shot = new SettingsSnapshot();
        shot.keywordsEnabled = !this.keyAllBtn.isSelected();
        shot.urlsEnabled = true;
        shot.statusEnabled = this.statusAnyOfBtn.isSelected();
        shot.jtxEnabled = this.jtxCheckBox.isSelected();
        shot.tsfEnabled = this.tsfCheckBox.isSelected();
        boolean oneSelected = false;
        shot.statusFields = new boolean[this.statusChecks.length];
        for (int i = 0; i < this.statusChecks.length; ++i) {
            shot.statusFields[i] = this.statusChecks[i].isSelected();
            oneSelected = oneSelected || shot.statusFields[i];
        }
        if (shot.statusEnabled && !oneSelected) {
            throw new IllegalStateException(this.uif.getI18NString("basicTf.badStatus"));
        }
        shot.initialUrls = this.testsField.getSelection();
        if (shot.initialUrls != null && shot.initialUrls.length == 1 && shot.initialUrls[0].isEmpty()) {
            shot.initialUrls = null;
        }
        shot.keyChoice = (String)this.keywordsChoice.getSelectedItem();
        shot.keyString = this.keywordsField.getText();
        return shot;
    }

    private void putSettings(SettingsSnapshot s) {
        if (this.editorPane == null) {
            return;
        }
        this.keyAllBtn.setSelected(!s.keywordsEnabled);
        this.keyMatchBtn.setSelected(s.keywordsEnabled);
        this.statusAllBtn.setSelected(!s.statusEnabled);
        this.statusAnyOfBtn.setSelected(s.statusEnabled);
        this.jtxCheckBox.setSelected(s.jtxEnabled);
        this.tsfCheckBox.setSelected(s.tsfEnabled);
        for (int i = 0; i < this.statusChecks.length; ++i) {
            this.statusChecks[i].setSelected(s.statusFields[i]);
        }
        this.testsField.setSelection(s.initialUrls);
        this.keywordsChoice.setSelectedItem(s.keyChoice);
        this.keywordsField.setText(s.keyString);
        this.updateExcludeInfo();
    }

    static {
        NUM_FILTERS = 5;
        KEY_FILTER = 0;
        URL_FILTER = 1;
        JTX_FILTER = 2;
        STATUS_FILTER = 3;
        TSS_FILTER = 4;
    }

    private class InterviewObserver
    implements Interview.Observer {
        private InterviewParameters interview;

        InterviewObserver(InterviewParameters i) {
            this.interview = i;
        }

        InterviewParameters getInterview() {
            return this.interview;
        }

        @Override
        public void currentQuestionChanged(Question q) {
        }

        @Override
        public void pathUpdated() {
            TestFilter underTest;
            InterviewParameters ip;
            boolean needsUpdate = false;
            BasicCustomTestFilter.this.updateExcludeInfo();
            if (((BasicCustomTestFilter)BasicCustomTestFilter.this).activeSettings.jtxEnabled && (ip = BasicCustomTestFilter.this.execModel.getInterviewParameters()) != null) {
                underTest = ip.getExcludeListFilter();
                if (!(underTest == null || BasicCustomTestFilter.this.jtxFilter != null && underTest.equals(BasicCustomTestFilter.this.jtxFilter))) {
                    needsUpdate = true;
                } else if (BasicCustomTestFilter.this.jtxFilter != null) {
                    needsUpdate = true;
                }
            }
            if (needsUpdate) {
                BasicCustomTestFilter.this.activateSettings(BasicCustomTestFilter.this.activeSettings);
                return;
            }
            if (((BasicCustomTestFilter)BasicCustomTestFilter.this).activeSettings.tsfEnabled) {
                ip = BasicCustomTestFilter.this.execModel.getInterviewParameters();
                TestSuite ts = BasicCustomTestFilter.this.execModel.getTestSuite();
                if (ip != null && ts != null) {
                    underTest = ts.createTestFilter(ip.getEnv());
                    if (underTest != null) {
                        if (BasicCustomTestFilter.this.tsfFilter == null || !underTest.equals(BasicCustomTestFilter.this.tsfFilter)) {
                            needsUpdate = true;
                        }
                    } else if (BasicCustomTestFilter.this.tsfFilter != null) {
                        needsUpdate = true;
                    }
                }
            }
            if (needsUpdate) {
                BasicCustomTestFilter.this.activateSettings(BasicCustomTestFilter.this.activeSettings);
                return;
            }
        }
    }

    private static class SettingsSnapshot {
        private static final String MAP_URL_ENABLE = "urlsEnabled";
        private static final String MAP_KEY_ENABLE = "keyEnabled";
        private static final String MAP_STATUS_ENABLE = "statusEnable";
        private static final String MAP_JTX_ENABLE = "jtxEnable";
        private static final String MAP_TSF_ENABLE = "tsfEnable";
        private static final String MAP_URLS = "urls";
        private static final String MAP_KEY_CHOICE = "keyChoice";
        private static final String MAP_KEY_STRING = "keyString";
        private static final String MAP_STATUS_PREFIX = "status";
        boolean urlsEnabled = true;
        boolean keywordsEnabled;
        boolean statusEnabled;
        boolean jtxEnabled;
        boolean tsfEnabled;
        boolean[] statusFields = new boolean[4];
        String[] initialUrls;
        String keyChoice = "expr";
        String keyString = "";

        SettingsSnapshot() {
        }

        SettingsSnapshot(Map<String, String> m) {
            this();
            this.load(m);
        }

        public boolean equals(Object settings) {
            if (settings == null) {
                return false;
            }
            SettingsSnapshot incoming = (SettingsSnapshot)settings;
            if (!Arrays.equals(this.initialUrls, incoming.initialUrls)) {
                return false;
            }
            if (this.keywordsEnabled != incoming.keywordsEnabled) {
                return false;
            }
            if (!Objects.equals(this.keyChoice, incoming.keyChoice)) {
                return false;
            }
            if (this.keyString == null ? !Objects.equals(this.keyString, incoming.keyString) : !this.keyString.equals(incoming.keyString)) {
                return false;
            }
            if (this.statusEnabled != incoming.statusEnabled) {
                return false;
            }
            if (!Arrays.equals(this.statusFields, incoming.statusFields)) {
                return false;
            }
            if (this.jtxEnabled != incoming.jtxEnabled) {
                return false;
            }
            return this.tsfEnabled == incoming.tsfEnabled;
        }

        public int hashCode() {
            int result = this.keywordsEnabled ? 1 : 0;
            result = 31 * result + (this.statusEnabled ? 1 : 0);
            result = 31 * result + (this.jtxEnabled ? 1 : 0);
            result = 31 * result + (this.tsfEnabled ? 1 : 0);
            result = 31 * result + Arrays.hashCode(this.initialUrls);
            result = 31 * result + Arrays.hashCode(this.statusFields);
            result = 31 * result + (this.keyChoice != null ? this.keyChoice.hashCode() : 0);
            result = 31 * result + (this.keyString != null ? this.keyString.hashCode() : 0);
            return result;
        }

        void save(Map<String, String> map) {
            map.put(MAP_URL_ENABLE, this.booleanToInt(this.urlsEnabled));
            map.put(MAP_KEY_ENABLE, this.booleanToInt(this.keywordsEnabled));
            map.put(MAP_STATUS_ENABLE, this.booleanToInt(this.statusEnabled));
            map.put(MAP_JTX_ENABLE, this.booleanToInt(this.jtxEnabled));
            map.put(MAP_TSF_ENABLE, this.booleanToInt(this.tsfEnabled));
            for (int i = 0; i < this.statusFields.length; ++i) {
                map.put(MAP_STATUS_PREFIX + i, this.booleanToInt(this.statusFields[i]));
            }
            map.put(MAP_URLS, StringArray.join(this.initialUrls));
            map.put(MAP_KEY_CHOICE, this.keyChoice);
            map.put(MAP_KEY_STRING, this.keyString);
        }

        void load(Map<String, String> map) {
            this.urlsEnabled = this.intToBoolean(map.get(MAP_URL_ENABLE));
            this.keywordsEnabled = this.intToBoolean(map.get(MAP_KEY_ENABLE));
            this.statusEnabled = this.intToBoolean(map.get(MAP_STATUS_ENABLE));
            this.jtxEnabled = this.intToBoolean(map.get(MAP_JTX_ENABLE));
            this.tsfEnabled = this.intToBoolean(map.get(MAP_TSF_ENABLE));
            for (int i = 0; i < 4; ++i) {
                this.statusFields[i] = this.intToBoolean(map.get(MAP_STATUS_PREFIX + i));
            }
            this.initialUrls = StringArray.split(map.get(MAP_URLS));
            this.keyChoice = map.get(MAP_KEY_CHOICE);
            this.keyString = map.get(MAP_KEY_STRING);
            this.validate();
        }

        private void validate() {
            this.keyChoice = this.keyChoice.equals(BasicCustomTestFilter.ALL_OF) ? BasicCustomTestFilter.ALL_OF : (this.keyChoice.equals(BasicCustomTestFilter.ANY_OF) ? BasicCustomTestFilter.ANY_OF : (this.keyChoice.equals(BasicCustomTestFilter.EXPR) ? BasicCustomTestFilter.EXPR : BasicCustomTestFilter.ALL_OF));
        }

        String booleanToInt(boolean val) {
            if (val) {
                return "1";
            }
            return "0";
        }

        boolean intToBoolean(String num) {
            if (num == null) {
                return false;
            }
            return num.equals("1");
        }
    }
}

