/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.resource.webappexception.mapper;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;

@Path(value="resource/direct")
public class DirectResponseUsageResource {
    public static final String ENTITY = "DirectEntity";

    private static Response buildResponse(int status, String entity) {
        Response.ResponseBuilder rb = Response.status((int)status);
        if (entity != null) {
            rb.entity((Object)entity);
        }
        return rb.build();
    }

    public static String getReasonPhrase(int status) {
        return Response.status((int)status).build().getStatusInfo().getReasonPhrase();
    }

    private static Response buildResponse(int status, boolean entity) {
        Response.ResponseBuilder rb = Response.status((int)status);
        if (entity) {
            rb.entity((Object)DirectResponseUsageResource.getReasonPhrase(status));
        }
        return rb.build();
    }

    @Path(value="{id}")
    public Response getException(@PathParam(value="id") int id) {
        WebApplicationException wae = null;
        switch (id) {
            case 2000: {
                wae = new WebApplicationException(ENTITY, DirectResponseUsageResource.buildResponse(200, ENTITY));
                break;
            }
            case 4000: {
                wae = new ClientErrorException(ENTITY, DirectResponseUsageResource.buildResponse(400, ENTITY));
                break;
            }
            case 400: {
                wae = new BadRequestException(ENTITY, DirectResponseUsageResource.buildResponse(id, true));
                break;
            }
            case 403: {
                wae = new ForbiddenException(ENTITY, DirectResponseUsageResource.buildResponse(id, true));
                break;
            }
            case 406: {
                wae = new NotAcceptableException(ENTITY, DirectResponseUsageResource.buildResponse(id, true));
                break;
            }
            case 405: {
                wae = new NotAllowedException(ENTITY, DirectResponseUsageResource.buildResponse(id, true));
                break;
            }
            case 401: {
                wae = new NotAuthorizedException(ENTITY, DirectResponseUsageResource.buildResponse(id, true));
                break;
            }
            case 404: {
                wae = new NotFoundException(ENTITY, DirectResponseUsageResource.buildResponse(id, true));
                break;
            }
            case 415: {
                wae = new NotSupportedException(ENTITY, DirectResponseUsageResource.buildResponse(id, true));
                break;
            }
            case 3000: {
                wae = new RedirectionException(ENTITY, DirectResponseUsageResource.buildResponse(300, ENTITY));
                break;
            }
            case 5000: {
                wae = new ServerErrorException(ENTITY, DirectResponseUsageResource.buildResponse(500, ENTITY));
                break;
            }
            case 500: {
                wae = new InternalServerErrorException(ENTITY, DirectResponseUsageResource.buildResponse(id, true));
                break;
            }
            case 503: {
                wae = new ServiceUnavailableException(ENTITY, DirectResponseUsageResource.buildResponse(id, true));
            }
        }
        throw wae;
    }
}

