/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.request;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.webclient.http.HttpResponse;
import ee.jakarta.tck.ws.rs.ee.rs.core.request.RequestTest;
import ee.jakarta.tck.ws.rs.ee.rs.core.request.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since: Sat, 29 Oct 1994 19:43:31 GMT";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since: Sat, 29 Oct 1994 19:43:31 GMT";
    private static final String IF_NONE_MATCH = "If-None-Match: \"AAA\"";

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_core_request_web/RequestTest");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/core/request/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_request_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, RequestTest.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void getMethodGetRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "GetMethodGetTest"));
        this.setProperty("SEARCH_STRING", "PASSED");
        this.invoke();
    }

    @Test
    public void getMethodPutRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("PUT", "GetMethodPutTest"));
        this.setProperty("SEARCH_STRING", "PASSED");
        this.invoke();
    }

    @Test
    public void getMethodPostRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("POST", "GetMethodPostTest"));
        this.setProperty("SEARCH_STRING", "PASSED");
        this.invoke();
    }

    @Test
    public void getMethodDeleteRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("DELETE", "GetMethodDeleteTest"));
        this.setProperty("SEARCH_STRING", "PASSED");
        this.invoke();
    }

    @Test
    public void getMethodHeadRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("HEAD", "GetMethodHeadTest"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void selectVariantGetRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "SelectVariantTestGet"));
        this.setProperty("SEARCH_STRING", "PASSED");
        this.invoke();
    }

    @Test
    public void selectVariantPutRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("PUT", "SelectVariantTestPut"));
        this.setProperty("SEARCH_STRING", "PASSED");
        this.invoke();
    }

    @Test
    public void selectVariantPostRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("POST", "SelectVariantTestPost"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "POST");
        this.setProperty("SEARCH_STRING", "PASSED");
        this.invoke();
    }

    @Test
    public void selectVariantDeleteRequestTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("DELETE", "SelectVariantTestDelete"));
        this.setProperty("SEARCH_STRING", "PASSED");
        this.invoke();
    }

    @Test
    public void selectVariantResponseVaryTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "SelectVariantTestResponse"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: application/json");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept-Encoding: *");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept-Language: *");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
        HttpResponse response = this._testCase.getResponse();
        Header[] headers = response.getResponseHeaders("Vary");
        Assertions.assertTrue((headers.length != 0 ? 1 : 0) != 0, (String)"Expected at least 1 Vary response header");
        boolean accept = false;
        boolean lang = false;
        boolean encoding = false;
        for (Header header : headers) {
            for (String vary : header.getValue().split(",")) {
                lang |= vary.contains("Accept-Language");
                encoding |= vary.contains("Accept-Encoding");
                accept |= vary.contains("Accept") && !vary.contains("Accept-");
            }
        }
        Assertions.assertTrue((boolean)lang, (String)"Vary should contain Accept-Language");
        Assertions.assertTrue((boolean)encoding, (String)"Vary should contain Accept-Encoding");
        Assertions.assertTrue((boolean)accept, (String)"Vary should contain Accept");
    }

    @Test
    public void evaluatePreconditionsTagNullAndSimpleGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsSimpleGet"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsEntityTagIfMatchAAAGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsAAAGet"));
        this.setProperty("REQUEST_HEADERS", "If-Match: \"AAA\"");
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsEntityTagIfMatchBBBGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsAAAGet"));
        this.setProperty("REQUEST_HEADERS", "If-Match: \"BBB\"");
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.PRECONDITION_FAILED));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsEntityTagIfMatchAAAPutTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("PUT", "preconditionsAAAPut"));
        this.setProperty("REQUEST_HEADERS", "If-Match: \"AAA\"");
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsEntityTagIfMatchBBBPutTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("PUT", "preconditionsAAAPut"));
        this.setProperty("REQUEST_HEADERS", "If-Match: \"BBB\"");
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.PRECONDITION_FAILED));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsTagIfNonMatchAAAGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsAAAGet"));
        this.setProperty("REQUEST_HEADERS", IF_NONE_MATCH);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.PRECONDITION_FAILED));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsTagIfNonMatchAAAPutTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("PUT", "preconditionsAAAPut"));
        this.setProperty("REQUEST_HEADERS", IF_NONE_MATCH);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.PRECONDITION_FAILED));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsTagIfNonMatchGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsGet"));
        this.setProperty("REQUEST_HEADERS", IF_NONE_MATCH);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsTagIfNonMatchAAAHeadTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("HEAD", "preconditionsAAAHead"));
        this.setProperty("REQUEST_HEADERS", IF_NONE_MATCH);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.PRECONDITION_FAILED));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsIfNonMatchHeadTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("HEAD", "preconditionsHead"));
        this.setProperty("REQUEST_HEADERS", IF_NONE_MATCH);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsIfModSinceAgesAgoGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsAgesAgoGet"));
        this.setProperty("REQUEST_HEADERS", IF_MODIFIED_SINCE);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.PRECONDITION_FAILED));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsIfUnmodSinceAgesAgoGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsAgesAgoGet"));
        this.setProperty("REQUEST_HEADERS", IF_UNMODIFIED_SINCE);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsIfModSinceNowGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsNowGet"));
        this.setProperty("REQUEST_HEADERS", IF_MODIFIED_SINCE);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsIfUnmodSinceNowGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsNowGet"));
        this.setProperty("REQUEST_HEADERS", IF_UNMODIFIED_SINCE);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.PRECONDITION_FAILED));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsTagIfModAAASinceGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsAAAAgesAgoGet"));
        this.setProperty("REQUEST_HEADERS", IF_MODIFIED_SINCE);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.PRECONDITION_FAILED));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsTagIfUnmodSinceAAAGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsAAAAgesAgoGet"));
        this.setProperty("REQUEST_HEADERS", IF_UNMODIFIED_SINCE);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsTagIfModSinceNowAAAGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsNowAAAGet"));
        this.setProperty("REQUEST_HEADERS", IF_MODIFIED_SINCE);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
    }

    @Test
    public void evaluatePreconditionsTagIfUnmodSinceNowAAAGetTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "preconditionsNowAAAGet"));
        this.setProperty("REQUEST_HEADERS", IF_UNMODIFIED_SINCE);
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.PRECONDITION_FAILED));
        this.invoke();
    }
}

