/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.cookieparam;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.JaxrsParamClient;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityPrototype;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingExceptionGivenByName;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingWebApplicationException;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithConstructor;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithFromString;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithValueOf;
import ee.jakarta.tck.ws.rs.ee.rs.ParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.RuntimeExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.WebApplicationExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.cookieparam.CookieParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.cookieparam.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsParamClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_cookieparam_web/CookieParamTest");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false, name="cookieparam")
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/cookieparam/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_cookieparam_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, CookieParamTest.class, ParamEntityPrototype.class, ParamEntityWithConstructor.class, ParamEntityWithValueOf.class, ParamEntityWithFromString.class, ParamTest.class, JaxrsParamClient.CollectionName.class, ParamEntityThrowingWebApplicationException.class, ParamEntityThrowingExceptionGivenByName.class, RuntimeExceptionMapper.class, WebApplicationExceptionMapper.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void cookieParamTest() throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        boolean pass = true;
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("setcookie"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "setCookie=done");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "Set-Cookie:name1=value1");
        this.setProperty(JAXRSCommonClient.Property.SAVE_STATE, "true");
        try {
            this.invoke();
        }
        catch (Exception ex) {
            pass = false;
            sb.append("Test failed with: " + ex.getMessage());
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("verifycookie"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "name1=value1|verifyCookie=done");
        this.setProperty(JAXRSCommonClient.Property.USE_SAVED_STATE, "true");
        try {
            this.invoke();
        }
        catch (Exception ex) {
            pass = false;
            sb.append("Test failed with: " + ex.getMessage());
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed:" + sb));
    }

    @Test
    public void cookieParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithConstructorTest();
    }

    @Test
    public void cookieParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithValueOfTest();
    }

    @Test
    public void cookieParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithFromStringTest();
    }

    @Test
    public void cookieParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    @Test
    public void cookieParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    @Test
    public void cookieParamSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    @Test
    public void cookieFieldParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithConstructorTest();
    }

    @Test
    public void cookieFieldParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithValueOfTest();
    }

    @Test
    public void cookieFieldParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithFromStringTest();
    }

    @Test
    public void cookieFieldParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    @Test
    public void cookieFieldParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    @Test
    public void cookieFieldSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    @Test
    public void cookieParamThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.paramThrowingWebApplicationExceptionTest();
    }

    @Test
    public void cookieFieldThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.fieldThrowingWebApplicationExceptionTest();
    }

    @Test
    public void cookieParamThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        super.paramThrowingIllegalArgumentExceptionTest();
    }

    @Test
    public void cookieFieldParamThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        super.fieldThrowingIllegalArgumentExceptionTest();
    }

    @Override
    protected void paramEntityThrowingAfterRequestSet(String request) throws JAXRSCommonClient.Fault {
        this.createAndCheckCookie(request);
        if (request.contains(IllegalArgumentException.class.getSimpleName())) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Response.Status.BAD_REQUEST.name());
        }
        super.paramEntityThrowingAfterRequestSet(request);
    }

    private void createAndCheckCookie(String request) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(request));
        this.setProperty(JAXRSCommonClient.Property.SAVE_STATE, "true");
        this.invoke();
        this.checkCookie(request);
        this.setProperty(JAXRSCommonClient.Property.USE_SAVED_STATE, "true");
    }

    @Override
    protected void paramEntity(String request) throws JAXRSCommonClient.Fault {
        this.createAndCheckCookie(request);
        super.paramEntity(request);
    }

    @Override
    protected String buildRequest(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)JAXRSCommonClient.Request.GET).append(" ").append(this._contextRoot);
        sb.append("?todo=").append(param.replace("=", "%3d")).append(" HTTP/1.1");
        return sb.toString();
    }

    @Override
    protected String getDefaultValueOfParam(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append(param).append("=");
        sb.append(CookieParamTest.class.getSimpleName());
        return sb.toString();
    }

    private void checkCookie(String cookie) throws JAXRSCommonClient.Fault {
        Object[] headers;
        boolean found = false;
        String lowCookie = JAXRSClientIT.stripQuotesSpacesAndLowerCase(cookie);
        for (String string : headers = this.getResponseHeaders()) {
            String header = JAXRSClientIT.stripQuotesSpacesAndLowerCase(string);
            if (!header.startsWith("set-cookie") || !header.contains(lowCookie)) continue;
            found = true;
        }
        Assertions.assertTrue((boolean)found, (String)("Could not find cookie" + cookie + "in response headers:" + JaxrsUtil.iterableToString(";", headers)));
        JAXRSClientIT.logMsg("Found cookie", cookie, "as expected");
    }

    private static String stripQuotesSpacesAndLowerCase(String cookie) {
        return cookie.toLowerCase().replace("\"", "").replace("'", "").replace(" ", "");
    }
}

