/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.application;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.common.webclient.http.HttpResponse;
import ee.jakarta.tck.ws.rs.ee.rs.core.application.ApplicationHolderSingleton;
import ee.jakarta.tck.ws.rs.ee.rs.core.application.ApplicationServlet;
import ee.jakarta.tck.ws.rs.ee.rs.core.application.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;
    protected int expectedSingletons = 1;
    protected int expectedClasses = 1;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_core_application_web/ApplicationTest");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/core/application/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_application_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, ApplicationServlet.class, ApplicationHolderSingleton.class, JaxrsUtil.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void getSingletonsTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "GetSingletons"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
        Assertions.assertTrue((this.getReturnedNumber() == this.expectedSingletons ? 1 : 0) != 0, (String)("Application.getSingletons() return incorrect value:" + this.getReturnedNumber()));
    }

    @Test
    public void getClassesTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "GetClasses"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.invoke();
        Assertions.assertTrue((this.getReturnedNumber() == this.expectedClasses ? 1 : 0) != 0, (String)("Application.getClasses() return incorrect value:" + this.getReturnedNumber()));
    }

    @Test
    public void getPropertiesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("GET ", "properties"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.OK));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, TSAppConfig.KEYS[0]);
        this.invoke();
    }

    @Test
    public void defaultGetPropertiesIsEmptyTest() throws JAXRSCommonClient.Fault {
        Application application = new Application();
        Map properties = application.getProperties();
        JAXRSClientIT.assertNotNull(properties, "Default implementation is not empty map, but null");
        Assertions.assertTrue((boolean)properties.isEmpty(), (String)("Default implementation is not empty, but" + JaxrsUtil.mapToString(properties)));
        JAXRSClientIT.logMsg("Default implementation gets empty map as expected");
    }

    protected int getReturnedNumber() throws JAXRSCommonClient.Fault {
        String body;
        HttpResponse response = this._testCase.getResponse();
        try {
            body = response.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        return Integer.parseInt(body);
    }
}

