/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.client.webtarget;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class IteratedList<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 6628004256042593971L;
    protected Class<T> clazz;
    private List<T> newTs = new LinkedList<T>();

    public IteratedList(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void doWithAll(String methodName, Object ... args) throws JAXRSCommonClient.Fault {
        this.doLog(methodName, args);
        for (Object t : this) {
            this.callMethodWithArgs(t, methodName, args);
        }
        this.addAll(this.newTs);
        this.newTs.clear();
    }

    protected void doLog(String methodName, Object ... args) {
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(arg);
        }
        TestUtil.logMsg("Testing method " + methodName + "(" + sb.toString() + ")");
    }

    protected void callMethodWithArgs(T t, String methodName, Object ... args) throws JAXRSCommonClient.Fault {
        Method m = this.findTargetMethodByNameAndArgs(methodName, args);
        try {
            Object o = m.invoke(t, args);
            if (o != null) {
                T newt = this.clazz.cast(o);
                this.newTs.add(newt);
            }
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    protected Method findTargetMethodByNameAndArgs(String name, Object ... args) throws JAXRSCommonClient.Fault {
        Method[] ms;
        for (Method m : ms = this.clazz.getMethods()) {
            if (!m.getName().equals(name) || args.length != m.getParameterTypes().length || !this.isMethodOfArguments(m, args)) continue;
            return m;
        }
        throw new JAXRSCommonClient.Fault("Method " + name + " not found");
    }

    protected boolean isMethodOfArguments(Method m, Object ... args) {
        boolean is = true;
        Class<?>[] types = m.getParameterTypes();
        for (int i = 0; i != args.length; ++i) {
            if (types[i].isAssignableFrom(args[i].getClass())) continue;
            is = false;
        }
        return is;
    }
}

