/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.returntype;

import ee.jakarta.tck.ws.rs.common.AbstractMessageBodyRW;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.EntityMessageWriter;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.ReadableWritableEntity;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.returntype.ReturnTypeTest;
import ee.jakarta.tck.ws.rs.spec.returntype.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.returntype.UUIDWriter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 6121223518891332649L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_returntype_web/ReturnTypeTest");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/returntype/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_returntype_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, ReturnTypeTest.class, UUIDWriter.class, EntityMessageWriter.class, ReadableWritableEntity.class, AbstractMessageBodyRW.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void voidTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "void"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    @Test
    public void nullEntityResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "nullEntityResponse"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    @Test
    public void nullResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "nullResponse"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    @Test
    public void nullGenericEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "nullGenericEntityTest"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    @Test
    public void genericEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "genericEntityTest"));
        UUID uuid = new UUID(6121223518891332649L, 3060611759445666324L);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, uuid.toString());
        this.invoke();
    }

    @Test
    public void nullEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "nullEntityTest"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    @Test
    public void defaultStatusTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "default"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "I am OK");
        this.invoke();
    }

    @Test
    public void entityBodyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entitybodytest"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(6121223518891332649L));
        this.invoke();
    }

    @Test
    public void entityResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entitybodyresponsetest"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(6121223518891332649L));
        this.invoke();
    }

    @Test
    public void notAcceptableTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "notAcceptable"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }
}

