/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.resource.webappexception.nomapper;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.resource.webappexception.nomapper.Resource;
import ee.jakarta.tck.ws.rs.ee.resource.webappexception.nomapper.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_resource_webappexception_nomapper_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/resource/webappexception/nomapper/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_resource_webappexception_nomapper_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void emptyConstructorTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "EmptyConstructor"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
    }

    @Test
    public void statusCode404Test() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "StatusCode404"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }

    @Test
    public void statusCode401Test() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "StatusCode401"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.UNAUTHORIZED));
        this.invoke();
    }

    @Test
    public void status503Test() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "Status503"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.SERVICE_UNAVAILABLE));
        this.invoke();
    }

    @Test
    public void status415Test() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "Status415"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void responseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "ResponseTest"));
        this.setProperty("SEARCH_STRING", "CTS-WebApplicationExceptionTest");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD: CTS-WebApplicationExceptionTest");
        this.invoke();
    }

    @Test
    public void nullResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "NullResponseTest"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
    }

    @Test
    public void getResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "getResponseTest"));
        this.setProperty("SEARCH_STRING", "CTS-WebApplicationExceptionTest");
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD: CTS-WebApplicationExceptionTest");
        this.invoke();
    }

    @Test
    public void throwableTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "ThrowableTest"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, Resource.id("-throwableTest"));
        this.invoke();
    }

    @Test
    public void throwableResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "ThrowableResponseTest"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, "CTS-HEAD: CTS-WebApplicationExceptionTest");
        this.setProperty("SEARCH_STRING", "CTS-WebApplicationExceptionTest");
        this.setProperty("SEARCH_STRING", "throwableResponseTest");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, Resource.id("-FAIL"));
        this.invoke();
    }

    @Test
    public void throwableResponseTest1() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "ThrowableResponseTest1"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, Resource.id("-throwableResponseTest1-FAIL"));
        this.invoke();
    }

    @Test
    public void throwableStatusTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "ThrowableStatusTest"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.SEE_OTHER));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, Resource.id("-throwableStatusTest"));
        this.invoke();
    }

    @Test
    public void throwableStatusTest1() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "ThrowableNullStatusTest"));
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, Resource.id("-throwableNullStatusTest-FAIL"));
        this.setProperty("SEARCH_STRING", Resource.id("-throwableNullStatusTest-PASS"));
        this.invoke();
    }

    @Test
    public void throwableStatusCodeTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "ThrowableStatusCodeTest"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }
}

