/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.client.invocationbuilder;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JdkLoggingFilter;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.client.invocationbuilder.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.client.invocationbuilder.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = -8097693127928445210L;
    static final String[] METHODS = new String[]{"delete", "get", "options"};
    static final String[] ENTITY_METHODS = new String[]{"put", "post"};

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_client_invocationbuilder_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/client/invocationbuilder/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_client_invocationbuilder_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, JaxrsUtil.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void acceptLanguageByLocalesTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createBuilderForMethod("languages");
        builder = builder.acceptLanguage(new Locale[]{Locale.GERMAN, Locale.ITALIAN, Locale.FRENCH});
        String response = (String)builder.buildGet().invoke(String.class);
        String error = "Expected locale was not found in the response:";
        JAXRSClientIT.assertContainsIgnoreCase(response, Locale.GERMAN, error, response);
        JAXRSClientIT.assertContainsIgnoreCase(response, Locale.ITALIAN, error, response);
        JAXRSClientIT.assertContainsIgnoreCase(response, Locale.FRENCH, error, response);
    }

    @Test
    public void acceptLanguageByStringsTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createBuilderForMethod("languages");
        builder = builder.acceptLanguage(new String[]{this.langToString(Locale.GERMAN), this.langToString(Locale.ITALIAN), this.langToString(Locale.FRENCH)});
        String response = (String)builder.buildGet().invoke(String.class);
        String error = "Expected locale was not found in the response:";
        JAXRSClientIT.assertContainsIgnoreCase(response, Locale.GERMAN, error, response);
        JAXRSClientIT.assertContainsIgnoreCase(response, Locale.ITALIAN, error, response);
        JAXRSClientIT.assertContainsIgnoreCase(response, Locale.FRENCH, error, response);
    }

    @Test
    public void asyncTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createBuilderForMethod("forbid");
        AsyncInvoker async = builder.async();
        Assertions.assertTrue((async != null ? 1 : 0) != 0, (String)"Builder.async() does not work properly");
    }

    @Test
    public void buildTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        for (String method : METHODS) {
            Invocation.Builder builder = this.createBuilderForMethod(method);
            String response = (String)builder.build(method.toUpperCase()).invoke(String.class);
            JAXRSClientIT.assertContainsIgnoreCase(response, method, new Object[]{error, response});
        }
    }

    @Test
    public void buildWithEntityTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        for (String method : ENTITY_METHODS) {
            Invocation.Builder builder = this.createBuilderForMethod(method);
            Entity<String> entity = this.createEntity(method);
            String response = (String)builder.build(method.toUpperCase(), entity).invoke(String.class);
            JAXRSClientIT.assertContainsIgnoreCase(response, method, new Object[]{error, response});
        }
    }

    @Test
    public void buildDeleteTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        Invocation.Builder builder = this.createBuilderForMethod("delete");
        String response = (String)builder.buildDelete().invoke(String.class);
        JAXRSClientIT.assertContainsIgnoreCase(response, "delete", new Object[]{error, response});
    }

    @Test
    public void buildGetTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        Invocation.Builder builder = this.createBuilderForMethod("get");
        String response = (String)builder.buildGet().invoke(String.class);
        JAXRSClientIT.assertContainsIgnoreCase(response, "get", new Object[]{error, response});
    }

    @Test
    public void buildPostTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        Invocation.Builder builder = this.createBuilderForMethod("post");
        Entity<String> entity = this.createEntity("post");
        String response = (String)builder.buildPost(entity).invoke(String.class);
        JAXRSClientIT.assertContainsIgnoreCase(response, "post", new Object[]{error, response});
    }

    @Test
    public void buildPutTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        Invocation.Builder builder = this.createBuilderForMethod("put");
        Entity<String> entity = this.createEntity("put");
        String response = (String)builder.buildPut(entity).invoke(String.class);
        JAXRSClientIT.assertContainsIgnoreCase(response, "put", new Object[]{error, response});
    }

    @Test
    public void cacheControlTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        Invocation.Builder builder = this.createBuilderForMethod("headerstostring");
        CacheControl control = new CacheControl();
        control.setMaxAge(2);
        String response = ((String)builder.cacheControl(control).buildGet().invoke(String.class)).toLowerCase();
        JAXRSClientIT.assertContainsIgnoreCase(response, "max-age", new Object[]{error, response});
    }

    @Test
    public void cookieCookieTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        Invocation.Builder builder = this.createBuilderForMethod("cookie");
        Cookie cookie = new Cookie("tck", "cts");
        String response = (String)builder.cookie(cookie).buildGet().invoke(String.class);
        JAXRSClientIT.assertContainsIgnoreCase(response, "cts", new Object[]{error, response});
    }

    @Test
    public void cookieStringStringTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        Invocation.Builder builder = this.createBuilderForMethod("cookie");
        String response = (String)builder.cookie("tck", "cts").buildGet().invoke(String.class);
        JAXRSClientIT.assertContainsIgnoreCase(response, "cts", new Object[]{error, response});
    }

    @Test
    public void headerObjectTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        Invocation.Builder builder = this.createBuilderForMethod("headerstostring");
        String response = (String)builder.header("tck-header", (Object)"cts-header").buildGet().invoke(String.class);
        JAXRSClientIT.assertContainsIgnoreCase(response, "tck-header", new Object[]{error, response});
        JAXRSClientIT.assertContainsIgnoreCase(response, "cts-header", new Object[]{error, response});
    }

    @Test
    public void headersMultivaluedMapTest() throws JAXRSCommonClient.Fault {
        String error = "Unexpected response returned:";
        Invocation.Builder builder = this.createBuilderForMethod("headerstostring");
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.add((Object)"tck-header", (Object)"cts-header");
        String response = (String)builder.header("unexpected-header", (Object)"unexpected-header").headers((MultivaluedMap)map).buildGet().invoke(String.class);
        Assertions.assertTrue((!response.contains("unexpected-header") ? 1 : 0) != 0, (String)"unexpected-header found in the response");
        JAXRSClientIT.assertContainsIgnoreCase(response, "tck-header", new Object[]{error, response});
        JAXRSClientIT.assertContainsIgnoreCase(response, "cts-header", new Object[]{error, response});
    }

    @Test
    public void headersMultivaluedMapIsNullReplacesAllTest() throws JAXRSCommonClient.Fault {
        Invocation.Builder builder = this.createBuilderForMethod("headerstostring");
        String response = (String)builder.header("unexpected-header", (Object)"unexpected-header").headers((MultivaluedMap)null).buildGet().invoke(String.class);
        Assertions.assertTrue((!response.contains("unexpected-header") ? 1 : 0) != 0, (String)"unexpected-header found in the response");
    }

    protected String getUrl(String method) {
        StringBuilder url = new StringBuilder();
        url.append("http://").append(this._hostname).append(":").append(this._port);
        url.append(this.getContextRoot()).append("/").append(method);
        return url.toString();
    }

    protected Invocation.Builder createBuilderForMethod(String methodName) {
        Client client = ClientBuilder.newClient();
        client.register((Object)new JdkLoggingFilter(false));
        WebTarget target = client.target(this.getUrl(methodName));
        Invocation.Builder builder = target.request();
        return builder;
    }

    protected <T> Entity<T> createEntity(T entity) {
        return Entity.entity(entity, (MediaType)MediaType.WILDCARD_TYPE);
    }

    protected String langToString(Locale language) {
        return language.toString().replace("_", "-");
    }
}

