/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.filter.exception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.filter.exception.AbstractAddFilter;
import ee.jakarta.tck.ws.rs.spec.filter.exception.AbstractAddInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.exception.AddOneFilter;
import ee.jakarta.tck.ws.rs.spec.filter.exception.AddOneInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.exception.AddTenGlobalFilter;
import ee.jakarta.tck.ws.rs.spec.filter.exception.AddTenGlobalInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.exception.ExceptionNameBinding;
import ee.jakarta.tck.ws.rs.spec.filter.exception.NeverUsedExceptionMapper;
import ee.jakarta.tck.ws.rs.spec.filter.exception.PostMatchingThrowingFilter;
import ee.jakarta.tck.ws.rs.spec.filter.exception.PreMatchingThrowingFilter;
import ee.jakarta.tck.ws.rs.spec.filter.exception.Resource;
import ee.jakarta.tck.ws.rs.spec.filter.exception.RuntimeExceptionMapper;
import ee.jakarta.tck.ws.rs.spec.filter.exception.TSAppConfig;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_filter_exception_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/filter/exception/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_filter_exception_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, AbstractAddFilter.class, AbstractAddInterceptor.class, AddOneFilter.class, AddOneInterceptor.class, AddTenGlobalFilter.class, AddTenGlobalInterceptor.class, ExceptionNameBinding.class, NeverUsedExceptionMapper.class, PostMatchingThrowingFilter.class, PreMatchingThrowingFilter.class, RuntimeExceptionMapper.class, JaxrsUtil.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void throwExceptionOnPostMatchingFilterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "PostMatchingFilterThrowsException:100");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "11111");
        this.invoke();
        JAXRSClientIT.logMsg("Exception has been handled as expected");
    }

    @Test
    public void throwExceptionOnPreMatchingFilterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "PreMatchingFilterThrowsException:100");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "10110");
        this.invoke();
        JAXRSClientIT.logMsg("Exception has been handled as expected");
    }

    @Test
    public void throwExceptionOnInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "AddTenInterceptorThrowsException:100");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "11111");
        this.invoke();
        JAXRSClientIT.logMsg("Exception has been handled as expected");
    }

    @Test
    public void noNameBoundInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "nobinding"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "10020");
        this.invoke();
        JAXRSClientIT.logMsg("Only Globally bound interceptor has been invoked as expected");
    }

    @Test
    public void throwSecondExceptionFromMapperFirstFromInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "AddTenInterceptorThrowsException:ThrowExceptionOnceAgain");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
        JAXRSClientIT.logMsg("Exception has not been handled second time as expected");
    }

    @Test
    public void throwSecondExceptionFromMapperFirstFromPreMatchingFilterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "PreMatchingFilterThrowsException:ThrowExceptionOnceAgain");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
        JAXRSClientIT.logMsg("Exception has not been handled second time as expected");
    }

    @Test
    public void throwSecondExceptionFromMapperFirstFromPostMatchingFilterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "PostMatchingFilterThrowsException:ThrowExceptionOnceAgain");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
        JAXRSClientIT.logMsg("Exception has not been handled second time as expected");
    }

    @Test
    public void throwSecondExceptionFromInterceptorFirstFromInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "AddTenInterceptorThrowsException:AddTenInterceptorThrowsException");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
        JAXRSClientIT.logMsg("Exception has not been handled second time as expected");
    }

    @Test
    public void throwSecondExceptionFromInterceptorFirstFromPreMatchingFilterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "PreMatchingFilterThrowsException:AddTenInterceptorThrowsException");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
        JAXRSClientIT.logMsg("Exception has not been handled second time as expected");
    }

    @Test
    public void throwSecondExceptionFromInterceptorFirstFromPostMatchingFilterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "PostMatchingFilterThrowsException:AddTenInterceptorThrowsException");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
        JAXRSClientIT.logMsg("Exception has not been handled second time as expected");
    }

    @Test
    public void throwNoExceptionFromPostMatchingFilterFirstFromInterceptorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "AddTenInterceptorThrowsException:PostMatchingFilterThrowsException");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "111011");
        this.invoke();
        JAXRSClientIT.logMsg("Exception has not been handled second time as expected");
    }

    @Test
    public void throwNoExceptionFromPostMatchingFilterFirstFromPostMatchingFilterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "PostMatchingFilterThrowsException:PostMatchingFilterThrowsException");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "111011");
        this.invoke();
        JAXRSClientIT.logMsg("Exception has not been handled second time as expected");
    }

    @Test
    public void throwNoExceptionFromPostMatchingFilterFirstFromPreMatchingFilterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "PreMatchingFilterThrowsException:PostMatchingFilterThrowsException");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "110010");
        this.invoke();
        JAXRSClientIT.logMsg("Exception has not been handled second time as expected");
    }
}

