/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.common.impl;

import java.io.IOException;
import java.io.OutputStream;

public class ReplacingOutputStream
extends OutputStream {
    protected OutputStream wrappedStream;
    protected char what;
    protected char replace;
    protected String newMessage;

    public ReplacingOutputStream(OutputStream wrappedStream, char what, char replace) {
        this.wrappedStream = wrappedStream;
        this.what = what;
        this.replace = replace;
        this.newMessage = null;
    }

    public ReplacingOutputStream(OutputStream wrappedStream, String newMessage) {
        this.wrappedStream = wrappedStream;
        this.what = '\u0000';
        this.replace = '\u0000';
        this.newMessage = newMessage;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(ReplacingOutputStream.intToByteArray(b));
    }

    @Override
    public void write(byte[] b) throws IOException {
        String old = new String(b);
        String nw = null;
        if (this.what != '\u0000' && this.replace != '\u0000') {
            nw = old.replace(this.what, this.replace);
        }
        if (this.newMessage != null) {
            nw = this.newMessage;
        }
        this.wrappedStream.write(nw.getBytes());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(b);
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value & 0xFF)};
    }

    @Override
    public void close() throws IOException {
        if (this.wrappedStream != null) {
            this.wrappedStream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.wrappedStream != null) {
            this.wrappedStream.flush();
        }
    }
}

