/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.util.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class ResourceTable {
    private final Map<String, Thread> table;

    public ResourceTable() {
        this.table = new HashMap<String, Thread>();
    }

    public ResourceTable(int initialSize) {
        this.table = new HashMap<String, Thread>(initialSize);
    }

    public synchronized boolean acquire(String[] resourceNames, int timeout) throws InterruptedException {
        long start;
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout required");
        }
        if (resourceNames.length > 1) {
            TreeSet<String> ts = new TreeSet<String>(Arrays.asList(resourceNames));
            String[] s = new String[ts.size()];
            ts.toArray(s);
            resourceNames = s;
        }
        long now = start = System.currentTimeMillis();
        try {
            for (String resourceName : resourceNames) {
                Log.finer(Thread.currentThread() + " acquiring for " + resourceName);
                Thread owner = null;
                while ((owner = this.table.get(resourceName)) != null) {
                    long remain = start + (long)timeout - now;
                    if (remain <= 0L) {
                        this.release(resourceNames);
                        return false;
                    }
                    Log.finer(Thread.currentThread() + " waiting for resource: " + resourceName + " owned by " + owner);
                    this.wait(remain);
                    now = System.currentTimeMillis();
                }
                Log.finer(Thread.currentThread() + " putting " + resourceName);
                this.table.put(resourceName, Thread.currentThread());
            }
            return true;
        }
        catch (InterruptedException e) {
            this.release(resourceNames);
            throw e;
        }
    }

    public synchronized void release(String ... resourceNames) {
        for (String resourceName : resourceNames) {
            Thread owner = this.table.get(resourceName);
            if (owner != Thread.currentThread()) continue;
            Log.finer(owner + " releasing " + resourceName);
            this.table.remove(resourceName);
        }
        this.notifyAll();
    }

    public Map<String, Thread> table() {
        return Collections.unmodifiableMap(this.table);
    }
}

