/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Status;
import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.AgentRemoteClassData;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.InterruptableSocketConnection;
import com.sun.javatest.util.DynamicArray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AgentManager {
    private static final AgentManager theManager = new AgentManager();
    private static final int PASSIVE_AGENT_RETRY_LIMIT = 12;
    private Observer[] observers = new Observer[0];
    private ActiveAgentPool pool = new ActiveAgentPool();

    private AgentManager() {
    }

    public static AgentManager access() {
        return theManager;
    }

    public synchronized void addObserver(Observer o) {
        this.observers = DynamicArray.append(this.observers, o);
    }

    public synchronized void removeObserver(Observer o) {
        this.observers = DynamicArray.remove(this.observers, o);
    }

    private synchronized void notifyStarted(Connection connection, String tag, String request, String executable, String[] args, boolean localizeArgs) {
        for (Observer observer : this.observers) {
            observer.started(connection, tag, request, executable, args, localizeArgs);
        }
    }

    private synchronized void notifyFinished(Connection connection, Status status) {
        for (Observer observer : this.observers) {
            observer.finished(connection, status);
        }
    }

    public ActiveAgentPool getActiveAgentPool() {
        return this.pool;
    }

    public Task connect(Connection c) {
        return new Task(c);
    }

    public Task connectToActiveAgent() throws ActiveAgentPool.NoAgentException, InterruptedException, IOException {
        return this.connect(this.pool.nextAgent());
    }

    public Task connectToPassiveAgent(String host) throws IOException {
        if (host == null) {
            throw new NullPointerException();
        }
        return this.connectToPassiveAgent(host, 1908);
    }

    public Task connectToPassiveAgent(String host, int port) throws IOException {
        if (host == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (true) {
            try {
                return this.connect(new InterruptableSocketConnection(host, port));
            }
            catch (ConnectException e) {
                if (i == 12) {
                    throw e;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public class Task {
        private Connection connection;
        private DataInputStream in;
        private DataOutputStream out;
        private File[] classPath;
        private boolean sharedCl;
        private int timeout = 0;
        private Hashtable<File, ZipFile> zips = new Hashtable();

        Task(Connection c) {
            this.connection = c;
            this.in = new DataInputStream(new BufferedInputStream(c.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(c.getOutputStream()));
        }

        public Connection getConnection() {
            return this.connection;
        }

        public File[] getClassPath() {
            return this.classPath;
        }

        public void setClassPath(String path) {
            this.classPath = this.split(path);
        }

        public void setClassPath(File ... path) {
            if (path == null) {
                throw new NullPointerException();
            }
            for (File aPath : path) {
                if (aPath != null) continue;
                throw new IllegalArgumentException();
            }
            this.classPath = path;
        }

        public void setSharedClassLoader(boolean state) {
            this.sharedCl = state;
        }

        public void setAgentCommandTimeout(int timeout) {
            this.timeout = timeout;
        }

        public Status executeTest(String tag, String className, String[] args, boolean localizeArgs, PrintWriter log, PrintWriter ref) {
            return this.run(tag, "executeTest", className, args, localizeArgs, log, ref);
        }

        public Status executeCommand(String tag, String className, String[] args, boolean localizeArgs, PrintWriter log, PrintWriter ref) {
            return this.run(tag, "executeCommand", className, args, localizeArgs, log, ref);
        }

        public Status executeMain(String tag, String className, String[] args, boolean localizeArgs, PrintWriter log, PrintWriter ref) {
            return this.run(tag, "executeMain", className, args, localizeArgs, log, ref);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Status run(String tag, String request, String executable, String[] args, boolean localizeArgs, PrintWriter log, PrintWriter ref) {
            AgentManager.this.notifyStarted(this.connection, tag, request, executable, args, localizeArgs);
            Status result = null;
            try {
                this.out.writeShort(105);
                this.out.writeUTF(tag);
                this.out.writeUTF(request);
                this.out.writeUTF(executable);
                this.out.writeShort(args.length);
                for (String arg : args) {
                    this.out.writeUTF(arg);
                }
                this.out.writeBoolean(localizeArgs);
                this.out.writeBoolean(this.classPath != null);
                this.out.writeBoolean(this.sharedCl);
                this.out.writeInt(this.timeout);
                this.out.writeByte(0);
                this.out.flush();
                result = this.readResults(log, ref);
            }
            catch (IOException e) {
                try {
                    try {
                        if (this.out != null) {
                            this.out.close();
                        }
                        if (this.in != null) {
                            this.in.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    result = e instanceof InterruptedIOException ? Status.error("Communication with agent interrupted! (timed out?).\n InterruptedException: " + e) : Status.error("Problem communicating with agent: " + e);
                }
                catch (Throwable throwable) {
                    AgentManager.this.notifyFinished(this.connection, result);
                    throw throwable;
                }
                AgentManager.this.notifyFinished(this.connection, result);
            }
            AgentManager.this.notifyFinished(this.connection, result);
            return result;
        }

        private Status readResults(PrintWriter log, PrintWriter ref) throws IOException {
            Status status = null;
            while (status == null) {
                int code = this.in.read();
                block0 : switch (code) {
                    case -1: {
                        status = Status.error("premature EOF from agent");
                        break;
                    }
                    case 67: {
                        String className = this.in.readUTF();
                        AgentRemoteClassData classData = this.locateClass(className);
                        classData.write(this.out);
                        this.out.flush();
                        break;
                    }
                    case 68: {
                        String resourceName = this.in.readUTF();
                        byte[] resourceData = this.locateData(resourceName);
                        if (resourceData == null) {
                            this.out.writeInt(-1);
                        } else {
                            this.out.writeInt(resourceData.length);
                            this.out.write(resourceData, 0, resourceData.length);
                        }
                        this.out.flush();
                        break;
                    }
                    case 83: {
                        int type = this.in.read();
                        String reason = this.in.readUTF();
                        switch (type) {
                            case 0: {
                                status = Status.passed(reason);
                                break block0;
                            }
                            case 1: {
                                status = Status.failed(reason);
                                break block0;
                            }
                            case 2: {
                                status = Status.error(reason);
                                break block0;
                            }
                        }
                        status = Status.failed("Bad status from test: type=" + type + " reason=" + reason);
                        break;
                    }
                    case 76: {
                        log.write(this.in.readUTF());
                        break;
                    }
                    case 108: {
                        log.write(this.in.readUTF());
                        log.flush();
                        break;
                    }
                    case 82: {
                        ref.write(this.in.readUTF());
                        break;
                    }
                    case 114: {
                        ref.write(this.in.readUTF());
                        ref.flush();
                    }
                }
            }
            this.out.close();
            this.in.close();
            this.connection.close();
            log.flush();
            ref.flush();
            Enumeration<File> e = this.zips.keys();
            while (e.hasMoreElements()) {
                File f = e.nextElement();
                ZipFile z = this.zips.get(f);
                this.zips.remove(f);
                z.close();
            }
            return status;
        }

        private AgentRemoteClassData locateClass(String name) {
            if (this.classPath != null) {
                String cname = name.replace('.', '/') + ".class";
                for (File aClassPath : this.classPath) {
                    byte[] data = aClassPath.isDirectory() ? this.readFromDir(cname, aClassPath) : this.readFromJar(cname, aClassPath);
                    if (data == null) continue;
                    String codeSource = "";
                    try {
                        codeSource = aClassPath.toURI().toURL().getPath();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return new AgentRemoteClassData(name, codeSource, data);
                }
            }
            return AgentRemoteClassData.NO_CLASS_DATA;
        }

        private byte[] locateData(String name) {
            if (this.classPath != null) {
                for (File aClassPath : this.classPath) {
                    byte[] data = aClassPath.isDirectory() ? this.readFromDir(name, aClassPath) : this.readFromJar(name, aClassPath);
                    if (data == null) continue;
                    return data;
                }
            }
            return null;
        }

        private byte[] readFromDir(String name, File dir) {
            try {
                File file = new File(dir, name);
                return this.read(new FileInputStream(file), (int)file.length());
            }
            catch (IOException e) {
                return null;
            }
        }

        private byte[] readFromJar(String name, File jarFile) {
            try {
                ZipEntry ze;
                ZipFile z = this.zips.get(jarFile);
                if (z == null) {
                    z = new ZipFile(jarFile);
                    this.zips.put(jarFile, z);
                }
                if ((ze = z.getEntry(name)) == null) {
                    return null;
                }
                return this.read(z.getInputStream(ze), (int)ze.getSize());
            }
            catch (IOException e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] read(InputStream in, int size) throws IOException {
            try {
                int n;
                byte[] data = new byte[size];
                for (int total = 0; total < data.length; total += n) {
                    n = in.read(data, total, data.length - total);
                    if (n > 0) {
                        continue;
                    }
                    throw new EOFException("unexpected end of file");
                }
                byte[] byArray = data;
                return byArray;
            }
            finally {
                in.close();
            }
        }

        private File[] split(String s) {
            char pathCh = File.pathSeparatorChar;
            Vector<File> v = new Vector<File>();
            int start = 0;
            int i = s.indexOf(pathCh);
            while (i != -1) {
                this.add(s.substring(start, i), v);
                start = i + 1;
                i = s.indexOf(pathCh, start);
            }
            if (start != s.length()) {
                this.add(s.substring(start), v);
            }
            return v.toArray(new File[v.size()]);
        }

        private void add(String s, Vector<File> v) {
            if (!s.isEmpty()) {
                v.add(new File(s));
            }
        }
    }

    public static interface Observer {
        public void started(Connection var1, String var2, String var3, String var4, String[] var5, boolean var6);

        public void finished(Connection var1, Status var2);
    }
}

