/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.selectiontree.SelectionTree;
import com.sun.javatest.tool.selectiontree.selection.SelectionElement;
import com.sun.javatest.tool.selectiontree.selection.SelectionType;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.util.LinkedList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class TreeSelectionPane
extends JComponent
implements Accessible {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TreeSelectionPane.class);
    private AccessibleContext accessibleContext;
    private SelectionTree tree;
    private UIFactory uif = new UIFactory(this.getClass(), null);

    TreeSelectionPane(Model model) {
        this.setLayout(new BorderLayout());
        SelectNode rootNode = new SelectNode(model, model.getRoot());
        this.tree = new SelectionTree(rootNode, null, true);
        this.tree.setName("tsp.tree");
        AccessibleContext ac = this.tree.getAccessibleContext();
        ac.setAccessibleName(i18n.getString("tsp.tree.name"));
        ac.setAccessibleDescription(i18n.getString("tsp.tree.desc"));
        JScrollPane sp = this.uif.createScrollPane(this.tree);
        this.add(sp);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public String[] getSelection() {
        return this.tree.getSelection();
    }

    public void setSelection(String ... paths) {
        this.tree.setSelection(paths);
    }

    public boolean isSelectionEmpty() {
        return this.tree.isSelectionEmpty();
    }

    public void clear() {
        this.tree.setSelection(null);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.tree.setEnabled(b);
    }

    protected static class SelectNode
    implements SelectionElement {
        private SelectionType type = SelectionType.UNSELECTED;
        private Object object;
        private LinkedList<SelectionElement> children;
        private Model model;
        private String name;

        public SelectNode(Model model, Object object) {
            this.model = model;
            this.object = object;
        }

        @Override
        public SelectionType getSelectionType() {
            return this.type;
        }

        @Override
        public void setSelectionType(SelectionType selectionType) {
            if (!this.type.equals((Object)selectionType)) {
                this.type = selectionType;
            }
        }

        @Override
        public String getDisplayableName() {
            return this.getName();
        }

        @Override
        public String getToolTip() {
            return null;
        }

        @Override
        public boolean isToolTipAlwaysShown() {
            return false;
        }

        @Override
        public List<SelectionElement> getChildren() {
            if (this.children == null) {
                this.initChildren();
            }
            return this.children;
        }

        private void initChildren() {
            int childCount = this.model.getChildCount(this.object);
            this.children = new LinkedList();
            for (int i = 0; i < childCount; ++i) {
                SelectNode newChild = new SelectNode(this.model, this.model.getChild(this.object, i));
                this.children.add(newChild);
                if (!this.type.equals((Object)SelectionType.SELECTED)) continue;
                newChild.setSelectionType(SelectionType.SELECTED);
            }
            this.model.getChild(this.object, 0);
        }

        private String getName() {
            if (this.name == null) {
                this.name = this.model.getName(this.object);
            }
            return this.name;
        }
    }

    public static interface Model {
        public Object getRoot();

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public String getName(Object var1);

        public String getPath(Object var1);

        public boolean isLeaf(Object var1);
    }
}

