/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.ProductInfo;
import com.sun.javatest.Status;
import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.BadValue;
import com.sun.javatest.agent.ConfigValuesMap;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.Deck;
import com.sun.javatest.agent.Folder;
import com.sun.javatest.agent.Icon;
import com.sun.javatest.agent.ModeOptions;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Vector;

class AgentPanel
extends ScrollPane {
    private static final String[] statusCodes = new String[]{"PASS", "FAIL", "CHCK", "ERR ", "!RUN"};
    private MapReader mapReader;
    private Deck deck;
    private ErrorPanel errorPanel;
    private HelpPanel helpPanel;
    private Panel mainPanel;
    private Folder mainFolder;
    private ButtonPanel buttonPanel;
    private ParamPanel paramPanel;
    private StatsPanel statsPanel;
    private TaskPanel taskPanel;
    private HistoryList historyList;
    private AgentObserver agentObs;
    private Agent.Observer userObs;
    private boolean tracing;
    private PrintStream traceOut;
    private Agent currAgent;

    public AgentPanel(ModeOptions[] modeOptions, MapReader mr) {
        this.mapReader = mr;
        this.initGUI(modeOptions);
    }

    private static int getInt(String label, TextField field) throws BadValue {
        try {
            return Integer.parseInt(field.getText(), 10);
        }
        catch (NumberFormatException e) {
            throw new BadValue("Bad value in `" + label + "' field");
        }
    }

    public synchronized void setMode(String mode) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.paramPanel.setMode(mode);
    }

    public void setConcurrency(int conc) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.paramPanel.setConcurrency(conc);
    }

    public void setMapFile(String mapFile) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.paramPanel.setMapFile(mapFile);
    }

    public void setRetryDelay(int delay) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.paramPanel.setRetryDelay(delay);
    }

    public void setTracing(boolean state, PrintStream out) {
        this.tracing = state;
        this.traceOut = !state ? null : out;
    }

    public void setHistoryLimit(int limit) {
        if (this.currAgent != null) {
            throw new IllegalStateException();
        }
        this.historyList.setMaxTasks(limit);
    }

    public void addObserver(Agent.Observer userObs) {
        if (userObs == null) {
            throw new NullPointerException();
        }
        if (this.userObs != null) {
            throw new IllegalStateException("Only one observer can be registered.");
        }
        this.userObs = userObs;
    }

    public synchronized void start() {
        try {
            this.currAgent = this.paramPanel.createAgent();
            this.currAgent.setTracing(this.tracing);
            this.currAgent.addObserver(this.agentObs);
            if (this.userObs != null) {
                this.currAgent.addObserver(this.userObs);
            }
            Thread t = new Thread((Runnable)this.currAgent, "AgentPanel worker thread");
            t.start();
            this.paramPanel.setEnabled(false);
            this.buttonPanel.setStartEnabled(false);
            this.buttonPanel.setStopEnabled(true);
        }
        catch (BadValue e) {
            this.error(e.getMessages());
        }
        catch (SecurityException e) {
            String[] msgs = new String[]{"Security Exception", e.getMessage()};
            this.error(msgs);
        }
        catch (ConnectionFactory.Fault e) {
            String[] msgs = new String[]{"Cannot create connection", e.getMessage()};
            this.error(msgs);
        }
        catch (IOException e) {
            String[] msgs = new String[]{"Problem reading map file", e.getMessage()};
            this.error(msgs);
        }
    }

    public synchronized void stop() {
        this.buttonPanel.setStopEnabled(false);
        if (this.currAgent != null) {
            this.currAgent.interrupt();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets i = this.getInsets();
        Dimension d = this.deck.getPreferredSize();
        return new Dimension(i.left + d.width + i.right, i.top + d.height + i.bottom);
    }

    void showTask(TaskState task) {
        this.mainFolder.show(this.taskPanel);
        this.taskPanel.setTask(task);
    }

    private void initGUI(ModeOptions ... modeOptions) {
        this.agentObs = new AgentObserver();
        this.deck = new Deck();
        this.initMainPanel(modeOptions);
        this.deck.add(this.mainPanel);
        this.errorPanel = new ErrorPanel();
        this.deck.add(this.errorPanel);
        this.helpPanel = new HelpPanel();
        this.deck.add(this.helpPanel);
        this.add(this.deck);
    }

    Component initMainPanel(ModeOptions ... modeOptions) {
        this.mainPanel = new Panel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.mainFolder = new Folder();
        this.paramPanel = new ParamPanel(modeOptions);
        this.mainFolder.add("parameters", this.paramPanel);
        this.statsPanel = new StatsPanel();
        this.mainFolder.add("statistics", this.statsPanel);
        this.historyList = new HistoryList();
        this.mainFolder.add("history", this.historyList);
        this.taskPanel = new TaskPanel();
        this.mainFolder.add("selected task", this.taskPanel);
        c.insets.right = 10;
        c.insets.left = 10;
        c.insets.top = 10;
        this.mainPanel.add((Component)this.mainFolder, c);
        this.buttonPanel = new ButtonPanel();
        c.weighty = 0.0;
        c.insets.bottom = 20;
        this.mainPanel.add((Component)this.buttonPanel, c);
        return this.mainPanel;
    }

    private void setIdle() {
        this.paramPanel.setEnabled(true);
        this.buttonPanel.setStartEnabled(true);
        this.buttonPanel.setStopEnabled(false);
        this.currAgent = null;
        this.notifyAll();
    }

    private void showHelp() {
        this.deck.show(this.helpPanel);
    }

    private void error(String ... msgs) {
        for (String msg : msgs) {
            System.out.println(msg);
        }
        this.errorPanel.show(msgs);
        this.deck.show(this.errorPanel);
    }

    private void ackError() {
        this.deck.show(this.mainPanel);
    }

    private class ParamPanel
    extends Panel
    implements ItemListener {
        private Choice modeChoice;
        private Deck modeDeck;
        private TextField mapFileField;
        private Label concurrencyLabel;
        private TextField concurrencyField;
        private int retryDelay;

        ParamPanel(ModeOptions ... modeOptions) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints lc = new GridBagConstraints();
            lc.anchor = 13;
            GridBagConstraints fc = new GridBagConstraints();
            fc.fill = 2;
            fc.gridwidth = 0;
            fc.weightx = 1.0;
            fc.weighty = 0.0;
            this.add((Component)new Label("mode:"), lc);
            this.modeChoice = new Choice();
            this.modeDeck = new Deck();
            for (ModeOptions m : modeOptions) {
                if (m == null) continue;
                this.modeChoice.addItem(m.getModeName());
                this.modeDeck.add(m);
            }
            this.modeChoice.addItemListener(this);
            fc.weightx = 0.0;
            fc.gridwidth = 1;
            this.add((Component)this.modeChoice, fc);
            fc.insets.left = 20;
            fc.fill = 2;
            fc.gridwidth = 0;
            fc.weightx = 1.0;
            this.add((Component)this.modeDeck, fc);
            fc.insets.left = 0;
            this.add((Component)new Label("map:"), lc);
            this.mapFileField = new TextField();
            this.add((Component)this.mapFileField, fc);
            Label concurrencyLabel = new Label("concurrency:");
            this.add((Component)concurrencyLabel, lc);
            this.concurrencyField = new TextField("1", 3);
            fc.gridwidth = 1;
            fc.weightx = 0.0;
            this.add((Component)this.concurrencyField, fc);
            fc.gridwidth = 0;
            fc.weightx = 1.0;
            this.add((Component)new Label(), fc);
        }

        @Override
        public void setEnabled(boolean b) {
            this.modeChoice.setEnabled(b);
            for (int i = 0; i < this.modeDeck.getComponentCount(); ++i) {
                ModeOptions o = (ModeOptions)this.modeDeck.getComponent(i);
                o.setEnabled(b);
            }
            this.mapFileField.setEnabled(b);
            this.concurrencyField.setEnabled(b);
        }

        public void setMode(String modeName) {
            this.modeChoice.select(modeName);
            for (int i = 0; i < this.modeDeck.getComponentCount(); ++i) {
                ModeOptions m = (ModeOptions)this.modeDeck.getComponent(i);
                if (!modeName.equals(m.getModeName())) continue;
                this.modeDeck.show(m);
                return;
            }
        }

        public void setConcurrency(int conc) {
            this.concurrencyField.setText(Integer.toString(conc));
        }

        public void setMapFile(String mapFile) {
            this.mapFileField.setText(mapFile);
        }

        public void setRetryDelay(int delay) {
            this.retryDelay = delay;
        }

        public Agent createAgent() throws BadValue, ConnectionFactory.Fault, IOException {
            ConfigValuesMap map = AgentPanel.this.mapReader.read(this.mapFileField.getText());
            int concurrency = AgentPanel.getInt("concurrency", this.concurrencyField);
            if (!Agent.isValidConcurrency(concurrency)) {
                throw new BadValue("Bad value for `concurrency field': " + concurrency);
            }
            ModeOptions mo = (ModeOptions)this.modeDeck.getCurrentCard();
            try {
                ConnectionFactory cf = mo.createConnectionFactory(concurrency);
                Agent agent = new Agent(cf, concurrency);
                if (this.retryDelay > 0) {
                    agent.setRetryDelay(this.retryDelay);
                }
                agent.setMap(map);
                return agent;
            }
            catch (IllegalArgumentException e) {
                throw new BadValue(e.getLocalizedMessage());
            }
        }

        private Deck createModeDeck(Choice modeChoice) {
            return AgentPanel.this.deck;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ItemSelectable src = e.getItemSelectable();
            if (src == this.modeChoice) {
                String modeName = ((Choice)src).getSelectedItem();
                for (int i = 0; i < this.modeDeck.getComponentCount(); ++i) {
                    ModeOptions m = (ModeOptions)this.modeDeck.getComponent(i);
                    if (!modeName.equals(m.getModeName())) continue;
                    this.modeDeck.show(m);
                    return;
                }
            }
        }
    }

    private class HistoryList
    extends List
    implements ItemListener {
        private int maxTasks;
        private Vector<TaskState> tasks;

        HistoryList() {
            super(5, false);
            this.maxTasks = 10;
            this.tasks = new Vector();
            super.addItemListener(this);
        }

        public synchronized void addTask(TaskState task) {
            if (this.tasks.size() >= this.maxTasks) {
                for (int i = 0; i < this.tasks.size(); ++i) {
                    String s = this.getItem(i);
                    if (s.startsWith("CONN") || s.startsWith("EXEC")) continue;
                    this.tasks.remove(i);
                    super.remove(i);
                }
            }
            this.tasks.add(task);
            super.add("CONN " + task.connection.getName());
        }

        public synchronized TaskState getTask(Connection c) {
            for (TaskState ts : this.tasks) {
                if (ts.connection != c) continue;
                return ts;
            }
            throw new Error("AgentPanel.HistoryList.getTask: can't find socket");
        }

        public synchronized TaskState getSelectedTask() {
            return this.tasks.get(super.getSelectedIndex());
        }

        @Override
        public synchronized void removeAll() {
            this.tasks.clear();
            if (this.getItemCount() > 0) {
                super.removeAll();
            }
        }

        public synchronized void removeTask(TaskState task) {
            int index = this.tasks.indexOf(task);
            this.tasks.remove(index);
            super.remove(index);
        }

        public synchronized void setMaxTasks(int n) {
            this.maxTasks = n;
        }

        public synchronized void update(TaskState task, String state, String detail) {
            super.replaceItem(this.getKey(state, detail), this.tasks.indexOf(task));
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ItemSelectable src = e.getItemSelectable();
            if (src == this) {
                switch (e.getStateChange()) {
                    case 1: {
                        AgentPanel.this.showTask(this.getSelectedTask());
                        break;
                    }
                    case 702: {
                        AgentPanel.this.showTask(null);
                    }
                }
            }
        }

        private String getKey(String state, String detail) {
            return state + " " + detail;
        }
    }

    private class HelpPanel
    extends Panel
    implements ActionListener {
        HelpPanel() {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            Panel logoPanel = new Panel(new GridBagLayout());
            GridBagConstraints lpc = new GridBagConstraints();
            lpc.gridwidth = 0;
            lpc.weighty = 1.0;
            lpc.insets = new Insets(20, 20, 20, 20);
            Icon logoJava = this.createIcon("jticon.gif");
            if (logoJava != null) {
                lpc.anchor = 11;
                logoPanel.add((Component)logoJava, lpc);
            }
            GridBagConstraints lrc = new GridBagConstraints();
            lrc.weighty = 1.0;
            lrc.fill = 1;
            this.add((Component)logoPanel, lrc);
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 0;
            Panel infoPanel = new Panel(new GridBagLayout());
            Label nameLabel = new Label("JT Harness Agent");
            nameLabel.setFont(new Font("SansSerif", 1, 32));
            infoPanel.add((Component)nameLabel, c);
            Label versionLabel = new Label(ProductInfo.getVersion());
            versionLabel.setFont(new Font("SansSerif", 1, 24));
            infoPanel.add((Component)versionLabel, c);
            Label copyLabel1 = new Label("Copyright (c) 1996, 2018, Oracle and/or its affiliates. All rights reserved.");
            infoPanel.add((Component)copyLabel1, c);
            Label copyLabel2 = new Label("Use is subject to license terms.");
            infoPanel.add((Component)copyLabel2, c);
            String helpText = "  For full information on using the\n  JT Harness Agent, please refer to the\n     JT Harness User's Guide\n  and to the documentation for the\n  test suite you are using.\n";
            TextArea helpArea = new TextArea(helpText, 5, 35, 3);
            helpArea.setEditable(false);
            c.weightx = 1.0;
            c.weighty = 1.0;
            infoPanel.add((Component)helpArea, c);
            Button okBtn = new Button("OK");
            okBtn.addActionListener(this);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets.bottom = 10;
            infoPanel.add((Component)okBtn, c);
            lrc.weightx = 1.0;
            this.add((Component)infoPanel, lrc);
        }

        private Icon createIcon(String name) {
            try {
                URL url = this.getClass().getResource(name);
                if (url == null) {
                    return null;
                }
                return new Icon(url);
            }
            catch (Error | RuntimeException e) {
                return null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AgentPanel.this.ackError();
        }
    }

    private class ErrorPanel
    extends Panel
    implements ActionListener {
        private ErrorPanel() {
        }

        public synchronized void show(String ... msgs) {
            this.removeAll();
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 0;
            c.insets = new Insets(30, 30, 0, 30);
            for (String msg1 : msgs) {
                Label msg = new Label(msg1);
                this.add((Component)msg, c);
                c.insets.top = 0;
            }
            c.insets.top = 30;
            c.insets.bottom = 30;
            Button okBtn = new Button("OK");
            okBtn.addActionListener(this);
            this.add((Component)okBtn, c);
            this.validate();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AgentPanel.this.ackError();
        }
    }

    private class ButtonPanel
    extends Panel
    implements ActionListener {
        private Button startButton;
        private Button stopButton;
        private Button helpButton;

        ButtonPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            this.startButton = new Button("Start");
            this.startButton.addActionListener(this);
            this.add((Component)this.startButton, c);
            this.stopButton = new Button("Stop");
            this.stopButton.addActionListener(this);
            this.stopButton.setEnabled(false);
            this.add((Component)this.stopButton, c);
            this.helpButton = new Button("Help");
            this.helpButton.addActionListener(this);
            this.add((Component)this.helpButton, c);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.startButton) {
                AgentPanel.this.start();
            } else if (src == this.stopButton) {
                AgentPanel.this.stop();
            } else if (src == this.helpButton) {
                AgentPanel.this.showHelp();
            }
        }

        void setStartEnabled(boolean b) {
            this.startButton.setEnabled(b);
        }

        void setStopEnabled(boolean b) {
            this.stopButton.setEnabled(b);
        }
    }

    private class AgentObserver
    implements Agent.Observer {
        private AgentObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void started(Agent sl) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                AgentPanel.this.historyList.removeAll();
                AgentPanel.this.taskPanel.setTask(null);
                AgentPanel.this.statsPanel.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void errorOpeningConnection(Agent sl, Exception e) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                String[] msgs = new String[]{"error opening connection", e.getMessage()};
                AgentPanel.this.error(msgs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished(Agent sl) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                AgentPanel.this.setIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void openedConnection(Agent sl, Connection c) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState ts = new TaskState(c);
                AgentPanel.this.historyList.addTask(ts);
                if (AgentPanel.this.taskPanel.getTask() == null) {
                    AgentPanel.this.taskPanel.setTask(ts);
                }
                AgentPanel.this.statsPanel.startedTask(ts);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execTest(Agent sl, Connection c, String tag, String className, String ... args) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState ts = AgentPanel.this.historyList.getTask(c);
                ts.mode = 0;
                ts.tag = tag;
                ts.className = className;
                ts.args = args;
                AgentPanel.this.historyList.update(ts, "EXEC", tag);
                if (ts == AgentPanel.this.taskPanel.getTask()) {
                    AgentPanel.this.taskPanel.update();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execCommand(Agent sl, Connection c, String tag, String className, String ... args) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState ts = AgentPanel.this.historyList.getTask(c);
                ts.mode = 1;
                ts.tag = tag;
                ts.className = className;
                ts.args = args;
                AgentPanel.this.historyList.update(ts, "EXEC", tag);
                if (ts == AgentPanel.this.taskPanel.getTask()) {
                    AgentPanel.this.taskPanel.update();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execMain(Agent sl, Connection c, String tag, String className, String ... args) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState ts = AgentPanel.this.historyList.getTask(c);
                ts.mode = 2;
                ts.tag = tag;
                ts.className = className;
                ts.args = args;
                AgentPanel.this.historyList.update(ts, "EXEC", tag);
                if (ts == AgentPanel.this.taskPanel.getTask()) {
                    AgentPanel.this.taskPanel.update();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void result(Agent sl, Connection c, Status r) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState ts = AgentPanel.this.historyList.getTask(c);
                ts.status = r;
                if (ts == AgentPanel.this.taskPanel.getTask()) {
                    AgentPanel.this.taskPanel.update();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exception(Agent sl, Connection c, Throwable t) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState ts = AgentPanel.this.historyList.getTask(c);
                if (ts.tag == null) {
                    AgentPanel.this.historyList.removeTask(ts);
                } else {
                    AgentPanel.this.historyList.update(ts, "*IO*", ts.tag);
                }
                AgentPanel.this.statsPanel.finishedTask(ts, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Agent sl, Connection c) {
            AgentPanel agentPanel = AgentPanel.this;
            synchronized (agentPanel) {
                if (sl != AgentPanel.this.currAgent) {
                    return;
                }
                TaskState ts = AgentPanel.this.historyList.getTask(c);
                AgentPanel.this.historyList.update(ts, statusCodes[ts.status.getType()], ts.tag);
                AgentPanel.this.statsPanel.finishedTask(ts, true);
            }
        }
    }

    private static class TaskPanel
    extends Panel {
        private TaskState task;
        private Label clientField;
        private Label tagField;
        private Label classField;
        private TextField argsField;
        private Label resultField;

        TaskPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints lc = new GridBagConstraints();
            lc.anchor = 13;
            GridBagConstraints fc = new GridBagConstraints();
            fc.weightx = 1.0;
            fc.fill = 2;
            fc.gridwidth = 0;
            Label clientLabel = new Label("client:");
            this.add((Component)clientLabel, lc);
            this.clientField = new Label("");
            this.add((Component)this.clientField, fc);
            Label tagLabel = new Label("request:");
            this.add((Component)tagLabel, lc);
            this.tagField = new Label("");
            this.add((Component)this.tagField, fc);
            Label classLabel = new Label("class:");
            this.add((Component)classLabel, lc);
            this.classField = new Label("");
            this.add((Component)this.classField, fc);
            Label argsLabel = new Label("args:");
            this.add((Component)argsLabel, lc);
            this.argsField = new TextField("");
            this.argsField.setEditable(false);
            this.add((Component)this.argsField, fc);
            Label resultLabel = new Label("result:");
            this.add((Component)resultLabel, lc);
            this.resultField = new Label("");
            this.add((Component)this.resultField, fc);
        }

        TaskState getTask() {
            return this.task;
        }

        void setTask(TaskState ts) {
            this.task = ts;
            this.update();
        }

        void update() {
            if (this.task == null) {
                this.clientField.setText("");
                this.tagField.setText("");
                this.classField.setText("");
                this.argsField.setText("");
                this.resultField.setText("");
            } else {
                this.clientField.setText(this.task.connection.getName());
                this.tagField.setText(this.task.tag);
                this.classField.setText(this.task.className);
                String a = "";
                if (this.task.args != null) {
                    for (int i = 0; i < this.task.args.length; ++i) {
                        a = a + this.task.args[i] + " ";
                    }
                }
                this.argsField.setText(a);
                if (this.task.status == null) {
                    this.resultField.setText("");
                } else {
                    this.resultField.setText(this.task.status.toString());
                }
            }
        }
    }

    private static class StatsPanel
    extends Panel {
        private Vector<TaskState> tasks = new Vector();
        private int[] statusCounts = new int[4];
        private int exceptionsCount;
        private TextField activeField;
        private TextField[] statusFields = new TextField[4];
        private TextField exceptionsField;

        StatsPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints lc = new GridBagConstraints();
            lc.anchor = 13;
            GridBagConstraints fc = new GridBagConstraints();
            fc.weightx = 1.0;
            fc.anchor = 17;
            fc.gridwidth = 0;
            this.activeField = this.addField("currently active:", lc, fc);
            this.statusFields[0] = this.addField("passed:", lc, fc);
            this.statusFields[1] = this.addField("failed:", lc, fc);
            this.statusFields[2] = this.addField("error:", lc, fc);
            this.statusFields[3] = this.addField("not run:", lc, fc);
            this.exceptionsField = this.addField("exceptions:", lc, fc);
        }

        void reset() {
            int i;
            this.tasks.clear();
            for (i = 0; i < this.statusCounts.length; ++i) {
                this.statusCounts[i] = 0;
            }
            this.exceptionsCount = 0;
            this.activeField.setText("0");
            for (i = 0; i < this.statusCounts.length; ++i) {
                this.statusFields[i].setText("0");
            }
            this.exceptionsField.setText("0");
        }

        void startedTask(TaskState task) {
            this.tasks.add(task);
            this.activeField.setText(String.valueOf(this.tasks.size()));
        }

        void finishedTask(TaskState task, boolean completedNormally) {
            int index = this.tasks.indexOf(task);
            if (index == -1) {
                return;
            }
            this.tasks.remove(index);
            this.activeField.setText(String.valueOf(this.tasks.size()));
            if (!completedNormally) {
                this.exceptionsField.setText(String.valueOf(++this.exceptionsCount));
            }
            if (task.status != null) {
                int t;
                int n = t = task.status.getType();
                int n2 = this.statusCounts[n] + 1;
                this.statusCounts[n] = n2;
                this.statusFields[t].setText(String.valueOf(n2));
            }
        }

        private TextField addField(String name, GridBagConstraints lc, GridBagConstraints fc) {
            this.add((Component)new Label(name), lc);
            TextField f = new TextField("0", 10);
            f.setEditable(false);
            this.add((Component)f, fc);
            return f;
        }
    }

    private static class TaskState {
        static final int TEST = 0;
        static final int COMMAND = 1;
        static final int MAIN = 2;
        Connection connection;
        int mode;
        String tag;
        String className;
        String[] args;
        Status status;

        TaskState(Connection c) {
            this.connection = c;
        }
    }

    public static interface MapReader {
        public ConfigValuesMap read(String var1) throws IOException;
    }
}

