/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.Status;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;

public class I18NUtils {
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int ERROR = 2;
    public static final int NOT_RUN = 3;
    public static final int FILTERED_OUT = 4;
    public static final int NUM_STATES = 5;
    private static final String PASS_COLOR_PREF = "color.passed";
    private static final String FAIL_COLOR_PREF = "color.failed";
    private static final String ERR_COLOR_PREF = "color.error";
    private static final String NOTRUN_COLOR_PREF = "color.notrun";
    private static final String FILTERED_COLOR_PREF = "color.filter";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(I18NUtils.class);
    private static Color passedColor = I18NUtils.getPreferredColor("color.passed", "i18n.passed", 65280, true);
    private static Color failedColor = I18NUtils.getPreferredColor("color.failed", "i18n.failed", 0xFF0000, true);
    private static Color errorColor = I18NUtils.getPreferredColor("color.error", "i18n.error", 0x3F3FFF, true);
    private static Color notRunColor = I18NUtils.getPreferredColor("color.notrun", "i18n.notRun", 0xFFFFFF, true);
    private static Color filteredOutColor = I18NUtils.getPreferredColor("color.filter", "i18n.filtered", 0xA999999, true);
    private static String[] STATUS_STRINGS;

    public static Color getStatusColor(int status) {
        return I18NUtils.getColorForState(status);
    }

    public static Color getStatusBarColor(int status) {
        return I18NUtils.lighter(I18NUtils.getColorForState(status));
    }

    public static String getStatusString(int status) {
        if (STATUS_STRINGS == null) {
            I18NUtils.loadStatusStrings();
        }
        if (status < STATUS_STRINGS.length) {
            return STATUS_STRINGS[status];
        }
        return i18n.getString("i18n.unknown");
    }

    public static String getStatusMessage(Status status) {
        if (STATUS_STRINGS == null) {
            I18NUtils.loadStatusStrings();
        }
        return STATUS_STRINGS[status.getType()] + " " + status.getReason();
    }

    static Color getColorForState(int state) {
        switch (state) {
            case 0: {
                return passedColor;
            }
            case 1: {
                return failedColor;
            }
            case 2: {
                return errorColor;
            }
            case 3: {
                return notRunColor;
            }
            case 4: {
                return filteredOutColor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadStatusStrings() {
        Class<I18NUtils> clazz = I18NUtils.class;
        synchronized (I18NUtils.class) {
            if (STATUS_STRINGS == null) {
                STATUS_STRINGS = new String[5];
                for (int i = 0; i < 5; ++i) {
                    I18NUtils.STATUS_STRINGS[i] = i18n.getString("i18n.status" + i);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Color lighter(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[1] = hsb[1] * 0.75f;
        hsb[2] = Math.min(hsb[2] * 1.1f, 1.0f);
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }

    private static Color getI18NColor(String key, int deflt) {
        String value = i18n.getString(key + ".clr");
        try {
            if (value != null) {
                return Color.decode(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Color(deflt);
    }

    private static Color getPreferredColor(String pref, String bundle, int backup, boolean syncPrefs) {
        Color result = null;
        result = Color.getColor("javatest." + pref);
        if (result != null) {
            if (syncPrefs) {
                Preferences prefs = Preferences.access();
                prefs.setPreference(pref, Integer.toString(result.getRGB()));
            }
            return result;
        }
        Preferences prefs = Preferences.access();
        String val = prefs.getPreference(pref);
        if (val != null) {
            try {
                result = Color.decode(val);
            }
            catch (NumberFormatException e) {
                result = null;
            }
            if (result != null) {
                return result;
            }
        }
        result = I18NUtils.getI18NColor(bundle, backup);
        return result;
    }
}

