/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._double.minexclusive.minexclusive_4;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import jakarta.xml.bind.JAXBException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minExclusive4_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minExclusive4_ValidateCTTests test = new minExclusive4_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final double[] validValues = {3877207345453194.0001E214, 7563290780183318.7943E247
                                , Double.MAX_VALUE
                                , Double.POSITIVE_INFINITY};
    
    final double[] invalidValues = {3877207345453194E213, 0.0, -Double.MAX_VALUE
                                , Double.NEGATIVE_INFINITY, Double.NaN};
    
    JAXBElement<Double> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Unmarshalled001( ) {
        elemObj = (JAXBElement<Double>)unmarshal("minExclusive-4-1.xml");
        return testValid();
    }

    public Status Unmarshalled002( ) {
        elemObj = (JAXBElement<Double>)unmarshal("minExclusive-4-1.xml");
        return testInvalid();
    }

    public Status Created001( ) {
        elemObj = (JAXBElement<Double>)(new ObjectFactory()).createNISTSchemaDoubleMinExclusive4(1.0);
        
        return testValid();
    }


}

