/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.FloatQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FloatQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    protected float lwb;
    protected float upb;
    protected float range;
    protected float[] suggs;
    protected JButton resetBtn;

    @Override
    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        FloatQuestion q = (FloatQuestion)qq;
        this.lwb = q.getLowerBound();
        this.upb = q.getUpperBound();
        this.range = this.upb - this.lwb;
        this.suggs = q.getSuggestions();
        return this.createTextField(q, listener);
    }

    @Override
    public String getInvalidValueMessage(Question q) {
        return null;
    }

    protected JPanel createTextField(FloatQuestion q, ActionListener listener) {
        String[] strSuggs;
        int w = 1;
        while (this.range >= 10.0f) {
            this.range /= 10.0f;
            ++w;
        }
        if (this.lwb < 0.0f) {
            ++w;
        }
        w += 5;
        w = Math.min(w, 20);
        if (this.suggs == null) {
            strSuggs = null;
        } else {
            strSuggs = new String[this.suggs.length];
            for (int i = 0; i < this.suggs.length; ++i) {
                strSuggs[i] = String.valueOf(this.suggs[i]);
            }
        }
        float defVal = q.getDefaultValue();
        if (Float.isNaN(defVal)) {
            this.resetBtn = null;
        } else {
            this.resetBtn = new JButton(i18n.getString("flt.reset.btn"));
            this.resetBtn.setName("flt.reset.btn");
            this.resetBtn.setMnemonic(i18n.getString("flt.reset.mne").charAt(0));
            this.resetBtn.setToolTipText(i18n.getString("flt.reset.tip"));
        }
        TypeInPanel p = new TypeInPanel("flt.field", q, w, strSuggs, this.resetBtn, listener);
        if (this.resetBtn != null) {
            this.resetBtn.addActionListener(e -> {
                NumberFormat fmt = NumberFormat.getNumberInstance();
                p.setValue(fmt.format((Object)defVal));
            });
        }
        return p;
    }
}

