/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.adapters.model.adapter;

import ee.jakarta.tck.json.bind.customizedmapping.adapters.model.Animal;
import ee.jakarta.tck.json.bind.customizedmapping.adapters.model.Cat;
import ee.jakarta.tck.json.bind.customizedmapping.adapters.model.Dog;
import ee.jakarta.tck.json.bind.customizedmapping.adapters.model.adapter.AnimalJson;
import jakarta.json.bind.adapter.JsonbAdapter;

public class AnimalAdapter
implements JsonbAdapter<Animal, AnimalJson> {
    public AnimalJson adaptToJson(Animal animal) throws Exception {
        AnimalJson adapted = new AnimalJson();
        if (Cat.class.isAssignableFrom(animal.getClass())) {
            adapted.setType(AnimalJson.TYPE.CAT);
            adapted.setCuddly(((Cat)animal).isCuddly());
        } else if (Dog.class.isAssignableFrom(animal.getClass())) {
            adapted.setType(AnimalJson.TYPE.DOG);
            adapted.setBarking(((Dog)animal).isBarking());
        } else {
            adapted.setType(AnimalJson.TYPE.GENERIC);
        }
        adapted.setName(animal.getName());
        adapted.setAge(animal.getAge());
        adapted.setFurry(animal.isFurry());
        adapted.setWeight(animal.getWeight());
        return adapted;
    }

    public Animal adaptFromJson(AnimalJson adapted) throws Exception {
        Animal animal;
        switch (adapted.getType()) {
            case CAT: {
                animal = new Cat();
                ((Cat)animal).setCuddly(adapted.isCuddly());
                break;
            }
            case DOG: {
                animal = new Dog();
                ((Dog)animal).setBarking(adapted.isBarking());
                break;
            }
            default: {
                animal = new Animal();
            }
        }
        animal.setName(adapted.getName());
        animal.setAge(adapted.getAge());
        animal.setFurry(adapted.isFurry());
        animal.setWeight(adapted.getWeight());
        return animal;
    }
}

