/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.propertynames;

import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.DuplicateNameContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.PropertyNameCustomizationAccessorsContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.PropertyNameCustomizationContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.StringContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientAnnotatedPropertyContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientGetterAnnotatedPropertyContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientGetterPlusCustomizationAnnotatedFieldContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientGetterPlusCustomizationAnnotatedGetterContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientPlusCustomizationAnnotatedGetterContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientPlusCustomizationAnnotatedPropertyContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientPlusCustomizationAnnotatedSetterContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientPropertyContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientSetterAnnotatedPropertyContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientSetterPlusCustomizationAnnotatedFieldContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertynames.model.TransientSetterPlusCustomizationAnnotatedSetterContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.JsonbException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PropertyNameCustomizationTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testTransientField() {
        String jsonString = this.jsonb.toJson((Object)new TransientPropertyContainer(){
            {
                this.setInstance("String Value");
            }
        });
        MatcherAssert.assertThat((String)"Failed to ignore transient property during marshalling.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        TransientPropertyContainer unmarshalledObject = (TransientPropertyContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientPropertyContainer.class);
        MatcherAssert.assertThat((String)"Failed to ignore transient property during unmarshalling.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testTransientAnnotatedField() {
        String jsonString = this.jsonb.toJson((Object)new TransientAnnotatedPropertyContainer(){
            {
                this.setInstance("String Value");
            }
        });
        MatcherAssert.assertThat((String)"Failed to ignore JsonbTransient property during marshalling.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
        TransientAnnotatedPropertyContainer unmarshalledObject = (TransientAnnotatedPropertyContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientAnnotatedPropertyContainer.class);
        MatcherAssert.assertThat((String)"Failed to ignore JsonbTransient property during unmarshalling.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testTransientAnnotatedGetter() {
        String jsonString = this.jsonb.toJson((Object)new TransientGetterAnnotatedPropertyContainer(){
            {
                this.setInstance("String Value");
            }
        });
        MatcherAssert.assertThat((String)"Failed to ignore @JsonbTransient on getter during marshalling.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
    }

    @Test
    public void testTransientAnnotatedSetter() {
        TransientSetterAnnotatedPropertyContainer unmarshalledObject = (TransientSetterAnnotatedPropertyContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientSetterAnnotatedPropertyContainer.class);
        MatcherAssert.assertThat((String)"Failed to ignore @JsonbTransient on setter during unmarshalling.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testTransientPlusCustomizationAnnotatedField() {
        String message = "JsonbException not thrown for property annotated with both JsonbTransient and other Jsonb customization annotation.";
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new TransientPlusCustomizationAnnotatedPropertyContainer()), (String)message);
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientPlusCustomizationAnnotatedPropertyContainer.class), (String)message);
    }

    @Test
    public void testTransientPlusCustomizationAnnotatedGetter() {
        String message = "JsonbException not thrown for property annotated with JsonbTransient and getter with other Jsonb customization annotation.";
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new TransientPlusCustomizationAnnotatedGetterContainer()), (String)message);
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientPlusCustomizationAnnotatedGetterContainer.class), (String)message);
    }

    @Test
    public void testTransientPlusCustomizationAnnotatedSetter() {
        String message = "JsonbException not thrown for property annotated with JsonbTransient and setter with other Jsonb customization annotation.";
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new TransientPlusCustomizationAnnotatedSetterContainer()), (String)message);
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientPlusCustomizationAnnotatedSetterContainer.class), (String)message);
    }

    @Test
    public void testTransientGetterPlusCustomizationAnnotatedField() {
        String message = "JsonbException not thrown for getter annotated with JsonbTransient and property with other Jsonb customization annotation.";
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new TransientGetterPlusCustomizationAnnotatedFieldContainer()), (String)message);
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientGetterPlusCustomizationAnnotatedFieldContainer.class), (String)message);
    }

    @Test
    public void testTransientGetterPlusCustomizationAnnotatedGetter() {
        String message = "JsonbException not thrown for property annotated with JsonbTransient and getter with other Jsonb customization annotation.";
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new TransientGetterPlusCustomizationAnnotatedGetterContainer()), (String)message);
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientGetterPlusCustomizationAnnotatedGetterContainer.class), (String)message);
    }

    @Test
    public void testTransientSetterPlusCustomizationAnnotatedSetter() {
        String message = "JsonbException not thrown for property annotated with JsonbTransient and setter with other Jsonb customization annotation.";
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new TransientSetterPlusCustomizationAnnotatedSetterContainer()), (String)message);
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientSetterPlusCustomizationAnnotatedSetterContainer.class), (String)message);
    }

    @Test
    public void testTransientSetterPlusCustomizationAnnotatedField() {
        String message = "JsonbException not thrown for setter annotated with JsonbTransient and property with other Jsonb customization annotation.";
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new TransientSetterPlusCustomizationAnnotatedFieldContainer()), (String)message);
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientSetterPlusCustomizationAnnotatedFieldContainer.class), (String)message);
    }

    @Test
    public void testPropertyNameCustomization() {
        String jsonString = this.jsonb.toJson((Object)new PropertyNameCustomizationContainer(){
            {
                this.setInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to customize property name during marshalling using JsonbProperty annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        PropertyNameCustomizationContainer unmarshalledObject = (PropertyNameCustomizationContainer)this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\" }", PropertyNameCustomizationContainer.class);
        MatcherAssert.assertThat((String)"Failed to customize property name during unmarshalling using JsonbProperty annotation.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testPropertyNameCustomizationAccessors() {
        String jsonString = this.jsonb.toJson((Object)new PropertyNameCustomizationAccessorsContainer(){
            {
                this.setInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to customize property name during marshalling using JsonbProperty annotation on getter.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"getterInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        PropertyNameCustomizationAccessorsContainer unmarshalledObject = (PropertyNameCustomizationAccessorsContainer)this.jsonb.fromJson("{ \"setterInstance\" : \"Test String\" }", PropertyNameCustomizationAccessorsContainer.class);
        MatcherAssert.assertThat((String)"Failed to customize property name during unmarshalling using JsonbProperty annotation on setter.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testIdentityPropertyNamingStrategy() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-naming-strategy", (Object)"IDENTITY");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal property using PropertyNamingStrategy.IDENTITY.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"stringInstance\" : \"Test String\" }", StringContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal property using PropertyNamingStrategy.IDENTITY.", (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testLowerCaseWithDashesPropertyNamingStrategy() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-naming-strategy", (Object)"LOWER_CASE_WITH_DASHES");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal property using PropertyNamingStrategy.LOWER_CASE_WITH_DASHES.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"string-instance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"string-instance\" : \"Test String\" }", StringContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal property using PropertyNamingStrategy.LOWER_CASE_WITH_DASHES.", (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testLowerCaseWithUnderscoresPropertyNamingStrategy() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-naming-strategy", (Object)"LOWER_CASE_WITH_UNDERSCORES");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal property using PropertyNamingStrategy.LOWER_CASE_WITH_UNDERSCORES.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"string_instance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"string_instance\" : \"Test String\" }", StringContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal property using PropertyNamingStrategy.LOWER_CASE_WITH_UNDERSCORES.", (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testUpperCamelCasePropertyNamingStrategy() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-naming-strategy", (Object)"UPPER_CAMEL_CASE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal property using PropertyNamingStrategy.UPPER_CAMEL_CASE.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"StringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"StringInstance\" : \"Test String\" }", StringContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal property using PropertyNamingStrategy.UPPER_CAMEL_CASE.", (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testUpperCamelCaseWithSpacesPropertyNamingStrategy() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-naming-strategy", (Object)"UPPER_CAMEL_CASE_WITH_SPACES");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal property using PropertyNamingStrategy.UPPER_CAMEL_CASE_WITH_SPACES.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"String Instance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"String Instance\" : \"Test String\" }", StringContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal property using PropertyNamingStrategy.UPPER_CAMEL_CASE_WITH_SPACES.", (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testCaseInsensitivePropertyNamingStrategy() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-naming-strategy", (Object)"CASE_INSENSITIVE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal property using PropertyNamingStrategy.CASE_INSENSITIVE.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"stringInstance\" : \"Test String\" }", StringContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal property using PropertyNamingStrategy.CASE_INSENSITIVE.", (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testDuplicateName() {
        String message = "JsonbException not thrown for property name duplication as a result of property name customization.";
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)new DuplicateNameContainer()), (String)message);
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", DuplicateNameContainer.class), (String)message);
    }
}

