/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.signaturetest;

import ee.jakarta.tck.jsonp.signaturetest.SigTestData;
import ee.jakarta.tck.jsonp.signaturetest.SignatureTestDriver;
import ee.jakarta.tck.jsonp.signaturetest.SignatureTestDriverFactory;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class SigTest {
    private static final Logger LOGGER = Logger.getLogger(SigTest.class.getName());
    protected SignatureTestDriver driver;
    protected SigTestData testInfo;

    protected SignatureTestDriver getSigTestDriver() {
        if (this.driver == null) {
            this.driver = SignatureTestDriverFactory.getInstance("sigtest");
        }
        return this.driver;
    }

    protected String getPackageFile() {
        return this.getSigTestDriver().getPackageFileImpl(this.testInfo.getBinDir());
    }

    protected String getMapFile() {
        return this.getSigTestDriver().getMapFileImpl(this.testInfo.getBinDir());
    }

    protected String getRepositoryDir() {
        return this.getSigTestDriver().getRepositoryDirImpl(this.testInfo.getTSHome());
    }

    protected ArrayList<String> getUnlistedOptionalPackages() {
        return null;
    }

    protected abstract String[] getPackages();

    protected String[] getClasses() {
        return new String[0];
    }

    public void setup() {
        try {
            LOGGER.info("$$$ SigTest.setup() called");
            this.testInfo = new SigTestData();
            LOGGER.info("$$$ SigTest.setup() complete");
        }
        catch (Exception e) {
            LOGGER.info("Unexpected exception " + e.getMessage());
        }
    }

    public void cleanup() throws Fault {
        LOGGER.info("$$$ SigTest.cleanup() called");
        try {
            this.getSigTestDriver().cleanupImpl();
            LOGGER.info("$$$ SigTest.cleanup() returning");
        }
        catch (Exception e) {
            throw new Fault("Cleanup failed!", e);
        }
    }

    public static class SetupException
    extends Exception {
        private static final long serialVersionUID = -7616313680616499158L;
        public Exception e;

        public SetupException(String msg) {
            super(msg);
        }

        public SetupException(String msg, Exception e) {
            super(msg);
            this.e = e;
        }

        @Override
        public void printStackTrace() {
            if (this.e != null) {
                this.e.printStackTrace();
            } else {
                super.printStackTrace();
            }
        }

        @Override
        public void printStackTrace(PrintStream s) {
            if (this.e != null) {
                this.e.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (this.e != null) {
                this.e.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public Throwable getCause() {
            return this.e;
        }

        @Override
        public synchronized Throwable initCause(Throwable cause) {
            if (this.e != null) {
                throw new IllegalStateException("Can't overwrite cause");
            }
            if (!Exception.class.isInstance(cause)) {
                throw new IllegalArgumentException("Cause not permitted");
            }
            this.e = (Exception)cause;
            return this;
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = -1574745208867827913L;
        public Throwable t;

        public Fault(String msg) {
            super(msg);
            LOGGER.info(msg);
        }

        public Fault(String msg, Throwable t) {
            super(msg);
            this.t = t;
        }

        public Fault(Throwable t) {
            super(t);
            this.t = t;
        }

        @Override
        public void printStackTrace() {
            if (this.t != null) {
                this.t.printStackTrace();
            } else {
                super.printStackTrace();
            }
        }

        @Override
        public void printStackTrace(PrintStream s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public Throwable getCause() {
            return this.t;
        }

        @Override
        public synchronized Throwable initCause(Throwable cause) {
            if (this.t != null) {
                throw new IllegalStateException("Can't overwrite cause");
            }
            if (!Exception.class.isInstance(cause)) {
                throw new IllegalArgumentException("Cause not permitted");
            }
            this.t = (Exception)cause;
            return this;
        }
    }
}

