/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFStatus;
import com.sun.javatest.cof.COFTestAttribute;
import com.sun.javatest.cof.COFTestAttributes;
import com.sun.javatest.cof.COFTestCase;
import com.sun.javatest.cof.COFTestCases;
import com.sun.javatest.cof.MTL;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class COFTest
extends COFItem {
    protected static final Pattern idPattern = Pattern.compile(".*[^\\w\\.\\[\\]\\(\\)\\{\\},_\\-]([\\w\\.\\[\\]\\(\\)\\{\\},_\\-]+)");
    protected static final Pattern testCasePattern = Pattern.compile("^(.*): (Passed\\.|Failed\\.|Error\\.|Not\\ run\\.)(.*)");
    private static final Date badDate = new Date(0L);
    private static final String[] cofStatus = new String[4];
    static long count = 0L;
    static boolean noTestCases = false;
    static LinkedHashMap<String, String> xmlAttributes;
    static LinkedHashMap<String, String> xmlElements;
    static String xmlTagName;
    private static DateFormat[] dateFormats;
    final long idNum = count++;
    protected String analysis;
    protected List<String> appuse;
    protected COFTestAttributes attributes;
    protected String description;
    protected Date endtime;
    protected String id;
    protected String name;
    protected Date starttime;
    protected COFStatus status;
    protected COFTestCases testcases;
    private COFData cofData;

    COFTest(TestResult tr, COFData data) {
        String jo;
        this.cofData = data;
        this.status = new COFStatus();
        this.status.setValue(cofStatus[tr.getStatus().getType()]);
        this.status.setActual(tr.getStatus().getReason());
        this.fillTestCases(tr);
        this.checkLostTestCases(tr);
        this.setName(tr.getTestName());
        if (!tr.getStatus().isNotRun()) {
            this.setStarttime(COFTest.parseDate(tr, "start"));
            this.setEndtime(COFTest.parseDate(tr, "end"));
        }
        this.attributes = new COFTestAttributes();
        this.attributes.getAttribute().add(new COFTestAttribute("logfile", tr.getWorkRelativePath()));
        if (data.isInterviewParametersAvailable()) {
            try {
                if (!data.getInterviewParameters().getExcludeListFilter().accepts(tr.getDescription())) {
                    this.attributes.getAttribute().add(new COFTestAttribute("isOnExcludeList", "true"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((jo = this.cofData.get("jvmopt", null)) != null) {
            this.attributes.getAttribute().add(new COFTestAttribute("javaopt", jo));
        }
    }

    private static void initDateFormats() {
        Vector<DateFormat> v = new Vector<DateFormat>();
        v.add(DateFormat.getDateTimeInstance());
        v.add(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz"));
        v.add(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"));
        v.add(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS"));
        String s = System.getProperty("javatest.date.format");
        if (s != null) {
            v.add(new SimpleDateFormat(s));
        }
        dateFormats = v.toArray(new DateFormat[v.size()]);
    }

    private static Date parseDate(String s) {
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                Date d = dateFormats[i].parse(s);
                if (i > 0) {
                    DateFormat tmp = dateFormats[i];
                    System.arraycopy(dateFormats, 0, dateFormats, 1, i);
                    COFTest.dateFormats[0] = tmp;
                }
                return d;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return badDate;
    }

    private static Date parseDate(TestResult tr, String key) {
        try {
            String s = tr.getProperty(key);
            if (s != null && !s.isEmpty()) {
                return COFTest.parseDate(s);
            }
        }
        catch (TestResult.Fault e) {
            System.err.println(e);
        }
        return badDate;
    }

    protected void fillTestCases(TestResult tr) {
        if (noTestCases) {
            return;
        }
        this.testcases = new COFTestCases();
        int sCount = tr.getSectionCount();
        if (sCount == 0 && tr.getStatus().getType() != 3) {
            try {
                tr = new TestResult(new File(this.cofData.get("workdir") + File.separator + tr.getWorkRelativePath()));
                sCount = tr.getSectionCount();
            }
            catch (TestResult.ResultFileNotFoundFault e) {
                System.err.println(e.getMessage());
            }
            catch (TestResult.ReloadFault e) {
                System.err.println(tr.getFile());
            }
        }
        for (int i = 0; i < sCount; ++i) {
            try {
                String sectionOut = tr.getSection(i).getOutput("out1");
                if (sectionOut == null) continue;
                BufferedReader reader = new BufferedReader(new StringReader(sectionOut));
                String s = reader.readLine();
                while (s != null) {
                    Matcher m = testCasePattern.matcher(s);
                    if (m.matches()) {
                        COFTestCase tc = new COFTestCase();
                        COFStatus cStatus = new COFStatus();
                        String tcName = this.fixIncorrectTestCaseName(m.group(1));
                        if (tcName == null) {
                            s = reader.readLine();
                            continue;
                        }
                        tc.setName(tcName);
                        cStatus.setValue(cofStatus[Status.parse(m.group(2)).getType()]);
                        cStatus.setActual(m.group(3));
                        tc.setStatus(cStatus);
                        this.testcases.getTestcase().add(tc);
                    }
                    s = reader.readLine();
                }
                continue;
            }
            catch (TestResult.ReloadFault | IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkLostTestCases(TestResult tr) {
        MTL mtl = this.cofData.getMtl();
        if (mtl == null) {
            return;
        }
        List<COFTestCase> jtrCases = this.testcases.getTestcase();
        List<String> mtlTestCases = mtl.getTestCases(tr.getTestName());
        if (mtlTestCases != null && !mtlTestCases.isEmpty()) {
            for (COFTestCase jtrCase : jtrCases) {
                mtlTestCases.remove(jtrCase.name);
            }
            if (!mtlTestCases.isEmpty()) {
                for (String testCaseName : mtlTestCases) {
                    COFTestCase nTc = new COFTestCase();
                    COFStatus nStatus = new COFStatus();
                    nTc.setName(testCaseName);
                    String strS = cofStatus[tr.getStatus().getType()];
                    nStatus.setValue(strS);
                    this.testcases.getTestcase().add(nTc);
                }
            }
        }
    }

    public String getAnalysis() {
        if (this.analysis == null) {
            return "accept";
        }
        return this.analysis;
    }

    public void setAnalysis(String value) {
        this.analysis = value;
    }

    public List<String> getAppuse() {
        if (this.appuse == null) {
            this.appuse = new ArrayList<String>();
        }
        return this.appuse;
    }

    public COFTestAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(COFTestAttributes value) {
        this.attributes = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public Date getEndtime() {
        return this.endtime;
    }

    public void setEndtime(Date value) {
        this.endtime = value;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.name == null) {
            throw new IllegalStateException("Name was not set.");
        }
        Matcher m = idPattern.matcher(this.name);
        this.id = m.matches() ? m.group(1) + ":" + this.idNum : "test:" + this.idNum;
        return this.id;
    }

    @Override
    LinkedHashMap<String, String> getItemAttributes() {
        return xmlAttributes;
    }

    @Override
    LinkedHashMap<String, String> getItemElements() {
        return xmlElements;
    }

    @Override
    String getItemTagName() {
        return xmlTagName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Date getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Date value) {
        this.starttime = value;
    }

    public COFStatus getStatus() {
        return this.status;
    }

    public void setStatus(COFStatus value) {
        this.status = value;
    }

    public COFTestCases getTestcases() {
        return this.testcases;
    }

    public void setTestcases(COFTestCases value) {
        this.testcases = value;
    }

    private String fixIncorrectTestCaseName(String tcn) {
        return this.cofData.getCustomFilter().transformTestCaseName(tcn);
    }

    static {
        xmlElements = new LinkedHashMap();
        xmlAttributes = new LinkedHashMap();
        xmlElements.put("name", "name");
        xmlElements.put("appuse", "appuse");
        xmlElements.put("status", "status");
        xmlElements.put("testcases", "testcases");
        xmlElements.put("starttime", "starttime");
        xmlElements.put("endtime", "endtime");
        xmlElements.put("attributes", "attributes");
        xmlElements.put("description", "description");
        xmlAttributes.put("id", "id");
        xmlTagName = "test";
        COFTest.initDateFormats();
        COFTest.cofStatus[0] = "pass";
        COFTest.cofStatus[1] = "fail";
        COFTest.cofStatus[2] = "error";
        COFTest.cofStatus[3] = "did_not_run";
    }
}

