/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.linkjaxbadapter;

import ee.jakarta.tck.ws.rs.api.rs.core.linkjaxbadapter.Model;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.ext.RuntimeDelegate;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -5902280515880564932L;
    protected static final String url = "some://where.at:port/";
    protected static final String rel = "Relation";
    protected static final String media = "application/svg+xml";
    protected static final String title = "XTitleX";
    protected static final String[] param_names = new String[]{"name1", "name2"};
    protected static final String[] param_vals = new String[]{"val1", "val2"};

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void marshallTest() throws JAXRSCommonClient.Fault {
        Link link = RuntimeDelegate.getInstance().createLinkBuilder().uri(url).title(title).rel(rel).type(media).param(param_names[0], param_vals[0]).param(param_names[1], param_vals[1]).build(new Object[0]);
        Model model = new Model(link);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream(1000);
        JAXBContext jc = null;
        Marshaller marshaller = null;
        byte[] array = null;
        try {
            jc = JAXBContext.newInstance((Class[])new Class[]{Model.class});
            marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)model, (OutputStream)ostream);
            array = ostream.toByteArray();
            String string = new String(array, Charset.defaultCharset());
            JAXRSClientIT.assertContains(string, "link href=", new Object[]{"Marshalled Link", string, "does not contain expected uri reference field"});
            JAXRSClientIT.assertContains(string, url, new Object[]{"Marshalled Link", string, " does not contain expected uri reference", url});
            JAXRSClientIT.assertContains(string, media, new Object[]{"MediaType has not been marshalled in", string});
            JAXRSClientIT.assertContains(string, title, new Object[]{"Title has not been marshalled in", string});
            JAXRSClientIT.assertContains(string, rel, new Object[]{"Relation has not been marshalled in", string});
            JAXRSClientIT.assertContains(string, param_names[0], new Object[]{"parameter name", param_names[0], "has not been marshalled in", string});
            JAXRSClientIT.assertContains(string, param_names[1], new Object[]{"parameter name", param_names[1], "has not been marshalled in", string});
            JAXRSClientIT.assertContains(string, param_vals[0], new Object[]{"parameter value", param_vals[0], "has not been marshalled in", string});
            JAXRSClientIT.assertContains(string, param_vals[1], new Object[]{"parameter value", param_vals[1], "has not been marshalled in", string});
            JAXRSClientIT.logMsg("Marshalled Link contains expected", string);
        }
        catch (JAXBException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    @Test
    public void unmarshallTest() throws JAXRSCommonClient.Fault {
        Link link = RuntimeDelegate.getInstance().createLinkBuilder().uri(url).title(title).rel(rel).type(media).param(param_names[0], param_vals[0]).param(param_names[1], param_vals[1]).build(new Object[0]);
        Model model = new Model(link);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream(1000);
        JAXBContext jc = null;
        Marshaller marshaller = null;
        byte[] array = null;
        Unmarshaller unmarshaller = null;
        ByteArrayInputStream istream = null;
        Model unmarshalledModel = null;
        try {
            jc = JAXBContext.newInstance((Class[])new Class[]{Model.class});
            marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)model, (OutputStream)ostream);
            array = ostream.toByteArray();
            istream = new ByteArrayInputStream(array);
            jc = JAXBContext.newInstance((Class[])new Class[]{Model.class});
            unmarshaller = jc.createUnmarshaller();
            unmarshalledModel = (Model)unmarshaller.unmarshal((InputStream)istream);
            link = unmarshalledModel.getLink();
            JAXRSClientIT.assertContains(link.toString(), url, new Object[]{"unmarshalled link", link, "does not contain expected url", url});
            JAXRSClientIT.assertContains(link.getRel(), rel, new Object[]{"unmarshalled link", link, "does not contain expected relation", rel});
            JAXRSClientIT.assertContains(link.getTitle(), title, new Object[]{"unmarshalled link", link, "does not contain expected title", title});
            JAXRSClientIT.assertContains(link.getType(), media, new Object[]{"unmarshalled link", link, "does not contain expected media type", media});
            Assertions.assertTrue((link.getParams().size() > 2 ? 1 : 0) != 0, (String)("unmarshalled link " + link + " does not contain expected parameters"));
            JAXRSClientIT.assertContains((String)link.getParams().get(param_names[0]), param_vals[0], new Object[]{"unmarshalled link", link, "does not contain expected parameter", param_names[0], "=", param_vals[0]});
            JAXRSClientIT.assertContains((String)link.getParams().get(param_names[1]), param_vals[1], new Object[]{"unmarshalled link", link, "does not contain expected parameter", param_names[1], "=", param_vals[1]});
            JAXRSClientIT.logMsg("unmarshalled Link contains expected url, title, media type, and parameters", link);
        }
        catch (JAXBException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }
}

