/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;

public abstract class TemplateFilter
implements ContainerRequestFilter {
    public static final String OPERATION = "OPERATION";
    public static final String PROPERTYNAME = "getSetProperty";
    protected ContainerRequestContext requestContext;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Method[] methods;
        this.requestContext = requestContext;
        String operation = this.getHeaderString();
        for (Method method : methods = this.getClass().getMethods()) {
            if (!operation.equalsIgnoreCase(method.getName())) continue;
            try {
                method.invoke((Object)this, new Object[0]);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)e.getMessage()).build();
                requestContext.abortWith(response);
            }
        }
        Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)("Operation " + operation + " not implemented")).build();
        requestContext.abortWith(response);
    }

    protected static <T> String collectionToString(Collection<T> collection) {
        StringBuilder sb = new StringBuilder();
        for (T item : collection) {
            String replace = item.toString().toLowerCase().replace("_", "-").replace(" ", "");
            sb.append(replace).append(" ");
        }
        return sb.toString();
    }

    protected void abortWithEntity(String entity) {
        StringBuilder sb = new StringBuilder();
        if (entity != null) {
            sb.append(entity).append(";");
        }
        sb.append(this.getHeaderString());
        Response response = Response.ok((Object)sb.toString()).build();
        this.requestContext.abortWith(response);
    }

    protected boolean assertTrue(boolean conditionTrue, Object ... msg) {
        if (conditionTrue) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            for (Object str : msg) {
                sb.append(str).append(" ");
            }
        }
        Response response = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)sb.toString()).build();
        this.requestContext.abortWith(response);
        return true;
    }

    protected String getHeaderString() {
        MultivaluedMap headers = this.requestContext.getHeaders();
        return (String)headers.getFirst((Object)OPERATION);
    }
}

