/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer;

import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.InterceptorCallbackMethods;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.TemplateInterceptorBody;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;

public abstract class TemplateWriterInterceptor
implements WriterInterceptor,
InterceptorCallbackMethods {
    protected WriterInterceptorContext writerCtx;
    protected TemplateInterceptorBody<WriterInterceptorContext> interceptorBody;

    public TemplateWriterInterceptor(TemplateInterceptorBody<WriterInterceptorContext> interceptorBody) {
        this.interceptorBody = interceptorBody;
    }

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException {
        this.writerCtx = ctx;
        this.interceptorBody.executeMethod(this.writerCtx, this);
    }

    @Override
    public void writeEntity(String entity) {
        Type type = this.writerCtx.getGenericType();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz == InputStreamReader.class) {
                ByteArrayInputStream bis = new ByteArrayInputStream(entity.getBytes());
                InputStreamReader reader = new InputStreamReader(bis);
                this.writerCtx.setEntity((Object)reader);
            } else {
                this.writerCtx.setEntity((Object)entity);
            }
        }
    }

    @Override
    public Object proceed() throws IOException {
        this.writerCtx.proceed();
        return null;
    }

    @Override
    public String getHeaderString() {
        MultivaluedMap headers = this.writerCtx.getHeaders();
        return (String)headers.getFirst((Object)"OPERATION");
    }
}

