/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._byte.totaldigits.totaldigits_3;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class totalDigits3_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        totalDigits3_GetSetCTTests test = new totalDigits3_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "totalDigits-3-1.xml", "totalDigits-3-2.xml", "totalDigits-3-3.xml",
            "totalDigits-3-4.xml", "totalDigits-3-5.xml"
        };
        byte[] expectedValues = {(byte)4, (byte)15, (byte)119, (byte)5, (byte)43};
        byte[] anExpectedValues = {(byte)-128, (byte)-54, (byte)0, (byte)54, (byte)125};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Byte> elemObj = (JAXBElement<Byte>)unmarshal(xmlDocNames[i]);
            if (elemObj.getValue() != expectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (elemObj.getValue() != anExpectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        byte[] setValues = {(byte)-128, (byte)-54, (byte)0, (byte)54, (byte)125};
        byte[] anSetValues = {(byte)-126, (byte)-50, (byte)0, (byte)50, (byte)127};
        JAXBElement<Byte> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Byte>)(new ObjectFactory()).createNISTSchemaByteTotalDigits3(setValues[i]);
            
            if (elemObj.getValue() != setValues[i]){
                return Status.failed("dynamically created JAXBElement<Byte>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (elemObj.getValue() != anSetValues[i]){
                return Status.failed("dynamically created JAXBElement<Byte>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

