/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.Harness;
import com.sun.javatest.Script;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import java.util.Iterator;

public abstract class TestRunner {
    private WorkDirectory workDir;
    private BackupPolicy backupPolicy;
    private TestEnvironment env;
    private ExcludeList excludeList;
    private int concurrency;
    private Harness.Observer notifier;

    void setWorkDirectory(WorkDirectory wd) {
        this.workDir = wd;
    }

    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    public TestSuite getTestSuite() {
        return this.workDir.getTestSuite();
    }

    void setBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    void setEnvironment(TestEnvironment env) {
        this.env = env;
    }

    public TestEnvironment getEnvironment() {
        return this.env;
    }

    void setExcludeList(ExcludeList excludeList) {
        this.excludeList = excludeList;
    }

    public ExcludeList getExcludeList() {
        return this.excludeList;
    }

    public String[] getExcludedTestCases(TestDescription td) {
        return this.excludeList.getTestCases(td);
    }

    void setConcurrency(int conc) {
        this.concurrency = conc;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    void setNotifier(Harness.Observer notifier) {
        this.notifier = notifier;
    }

    void delegateNotifier(Script script) {
        script.setNotifier(this.notifier);
    }

    protected abstract boolean runTests(Iterator var1) throws InterruptedException;

    protected void notifyStartingTest(TestResult tr) {
        this.notifier.startingTest(tr);
    }

    protected void notifyFinishedTest(TestResult tr) {
        this.notifier.finishedTest(tr);
    }
}

