/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.listener.shutdown;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import java.net.URLEncoder;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.api.InSequence;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.session.listener.shutdown.InfoServlet;
import org.jboss.cdi.tck.tests.context.session.listener.shutdown.InitServlet;
import org.jboss.cdi.tck.tests.context.session.listener.shutdown.SessionScopedTestFlagClient;
import org.jboss.cdi.tck.tests.context.session.listener.shutdown.TestFlag;
import org.jboss.cdi.tck.tests.context.session.listener.shutdown.TestHttpSessionListener;
import org.jboss.cdi.tck.util.SimpleLogger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class SessionContextListenerShutdownTest
extends AbstractTest {
    private static final String ALPHA_DEPLOYMENT_NAME = "alpha";
    private static final String BRAVO_ARCHIVE_NAME = "bravo";
    @ArquillianResource
    Deployer deployer;

    @Deployment(name="alpha", managed=false, testable=false)
    public static WebArchive createFooTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withClasses(new Class[]{SessionScopedTestFlagClient.class, InitServlet.class, TestHttpSessionListener.class, SimpleLogger.class})).withWebXml((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createSessionConfig().sessionTimeout(Integer.valueOf(10)).up())).build();
    }

    @Deployment(name="bravo", managed=false, testable=false)
    public static WebArchive createBarTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withClasses(new Class[]{TestFlag.class, InfoServlet.class, SimpleLogger.class})).build();
    }

    @Test(groups={"integration"})
    @InSequence(value=1)
    public void deployArchives() {
        this.deployer.deploy(ALPHA_DEPLOYMENT_NAME);
        this.deployer.deploy(BRAVO_ARCHIVE_NAME);
    }

    @Test(groups={"integration"}, dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="session_context_ee", id="ac")
    public void testApplicationContextDestroyed(@ArquillianResource @OperateOnDeployment(value="alpha") URL alphaContext, @ArquillianResource @OperateOnDeployment(value="bravo") URL bravoContext) throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(String.valueOf(alphaContext) + "init?url=" + URLEncoder.encode(bravoContext.toExternalForm(), "UTF-8"));
        this.deployer.undeploy(ALPHA_DEPLOYMENT_NAME);
        TextPage info = (TextPage)webClient.getPage(String.valueOf(bravoContext) + "info?action=get");
        Assert.assertEquals((String)info.getContent(), (String)"true");
        this.deployer.undeploy(BRAVO_ARCHIVE_NAME);
    }
}

