/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.interceptor;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.interceptor.AroundInvokeIF;
import com.sun.ts.tests.ejb30.common.interceptor.Constants;
import jakarta.ejb.EJBException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Properties;

public abstract class ClientBase
extends EETest
implements Constants {
    protected Properties props;

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
    }

    public void cleanup() throws Exception {
    }

    protected void remove() {
        if (this.getBean() != null) {
            try {
                this.getBean().remove();
                TLogger.log("bean removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("failed to remove bean.");
            }
        }
    }

    public void getBeanTest() throws Exception {
        try {
            this.getBean().getBeanTest();
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void getParametersTest() throws Exception {
        String expected = "old param value";
        String result = null;
        try {
            result = this.getBean().getParametersTest("old param value");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
        if (!expected.equals(result)) {
            throw new Exception("Expected " + expected + ", actual " + result);
        }
    }

    public void getParametersEmptyTest() throws Exception {
        try {
            this.getBean().getParametersEmptyTest();
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void setParametersTest() throws Exception {
        String expected = "new param value";
        String result = null;
        try {
            result = this.getBean().setParametersTest("old param value");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
        if (!expected.equals(result)) {
            throw new Exception("Expected " + expected + ", actual " + result);
        }
    }

    public void getContextDataTest() throws Exception {
        try {
            this.getBean().getContextDataTest();
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void getMethodTest() throws Exception {
        try {
            this.getBean().getMethodTest();
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void txRollbackOnlyTest() throws Exception {
        try {
            this.getBean().txRollbackOnlyTest();
        }
        catch (CalculatorException e) {
            throw new Exception("tx not rolled back properly.", e);
        }
        catch (Exception e) {
            throw new Exception("Unexpected exception", e);
        }
    }

    public void txRollbackOnlyAfterTest() throws Exception {
        try {
            this.getBean().txRollbackOnlyAfterTest();
        }
        catch (CalculatorException e) {
            throw new Exception("tx not rolled back properly.", e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sameSecContextTest() throws Exception {
        boolean expected = true;
        boolean result = false;
        try {
            result = this.getBean().sameSecContextTest();
        }
        catch (CalculatorException e) {
            throw new Exception("Test failed:", e);
        }
        catch (Exception e) {
            throw new Exception("Test failed:", e);
        }
        if (result != expected) {
            throw new Exception("Expected " + expected + ", actual=" + result + ".");
        }
    }

    public void exceptionTest() throws Exception {
        String expected = null;
        String result = null;
        try {
            result = this.getBean().exceptionTest();
        }
        catch (CalculatorException e) {
            TLogger.log("got expected exceptioin.");
        }
        catch (Exception e) {
            throw new Exception("Expected a CalculatorException, actual ", e);
        }
        if (result != null) {
            throw new Exception("Expected " + expected + ", actual=" + result + ".");
        }
    }

    public void suppressExceptionTest() throws Exception {
        try {
            this.getBean().suppressExceptionTest();
        }
        catch (CalculatorException e) {
            throw new Exception("This exception should have been supressed by interceptor.", e);
        }
        catch (Exception e) {
            throw new Exception("Unexpected exception", e);
        }
    }

    public void runtimeExceptionTest() throws Exception {
        try {
            this.getBean().runtimeExceptionTest();
            throw new Exception("Should not get here. RuntimeException should've been thrown from AroundInvoke method.");
        }
        catch (CalculatorException e) {
            throw new Exception("tx not rolled back properly.", e);
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                TLogger.log("Got RemoteException, OK.");
            } else if (e instanceof EJBException) {
                TLogger.log("Got EJBException, OK.");
            } else {
                if (e instanceof RuntimeException) {
                    throw new Exception("Got RuntimeException. It should not be thrown to the client.");
                }
                throw new Exception("Unexpected exception: " + String.valueOf(e.getClass()), e);
            }
            return;
        }
    }

    public void runtimeExceptionAfterTest() throws Exception {
        try {
            this.getBean().runtimeExceptionAfterTest();
            throw new Exception("Should not get here. RuntimeException should've been thrown from AroundInvoke method.");
        }
        catch (CalculatorException e) {
            throw new Exception("tx not rolled back properly.", e);
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                TLogger.log("Got RemoteException, OK.");
            } else if (e instanceof EJBException) {
                TLogger.log("Got EJBException, OK.");
            } else {
                if (e instanceof RuntimeException) {
                    throw new Exception("Got RuntimeException. It should not be thrown to the client.");
                }
                throw new Exception("Unexpected exception: " + String.valueOf(e.getClass()), e);
            }
            return;
        }
    }

    public void orderTest() throws Exception {
        try {
            this.getBean().orderTest();
        }
        catch (CalculatorException e) {
            throw new Exception("Test failed.", e);
        }
        catch (Exception e) {
            throw new Exception("Unexpected exception", e);
        }
    }

    public void sameInvocationContextTest() throws Exception {
        try {
            this.getBean().sameInvocationContextTest();
        }
        catch (CalculatorException e) {
            throw new Exception("Test failed.", e);
        }
        catch (Exception e) {
            throw new Exception("Unexpected exception", e);
        }
    }

    public void methodLevelInterceptorMixedTest() throws CalculatorException {
        String firstMethodInterceptor = "InterceptorNoat1";
        String secondMethodInterceptor = "Interceptor1";
        String shortBeanName = "AroundInvokeBean";
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(firstMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(shortBeanName);
        ArrayList<String> result = this.getBean().methodLevelInterceptorMixedTest(new ArrayList<String>());
        if (!expected.equals(result)) {
            throw new CalculatorException("Method-level interceptors are not invoked in the correct order. Expecting " + String.valueOf(expected) + ", actual " + String.valueOf(result));
        }
        TLogger.log("Method-level interceptors are invoked in the correct order: " + String.valueOf(result));
    }

    public void methodLevelClassLevelInterceptorMixedTest() throws CalculatorException {
        String firstMethodInterceptor = "Interceptor1";
        String secondMethodInterceptor = "InterceptorNoat1";
        String firstClassInterceptor = "Interceptor1";
        String secondClassInterceptor = "InterceptorNoat1";
        String shortBeanName = "AroundInvokeBean";
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(firstClassInterceptor);
        expected.add(firstClassInterceptor);
        expected.add(secondClassInterceptor);
        expected.add(secondClassInterceptor);
        expected.add(firstMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(shortBeanName);
        ArrayList<String> result = this.getBean().methodLevelClassLevelInterceptorMixedTest(new ArrayList<String>());
        if (!expected.equals(result)) {
            throw new CalculatorException("Method-level interceptors are not invoked in the correct order. Expecting " + String.valueOf(expected) + ", actual " + String.valueOf(result));
        }
        TLogger.log("Method-level interceptors are invoked in the correct order: " + String.valueOf(result));
    }

    public void repeatedInterceptors() throws CalculatorException {
        String firstMethodInterceptor = "InterceptorNoat1";
        String secondMethodInterceptor = "Interceptor1";
        String firstClassInterceptor = "Interceptor1";
        String secondClassInterceptor = "InterceptorNoat1";
        String shortBeanName = "AroundInvokeBean";
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(firstClassInterceptor);
        expected.add(firstClassInterceptor);
        expected.add(secondClassInterceptor);
        expected.add(secondClassInterceptor);
        expected.add(firstMethodInterceptor);
        expected.add(firstMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(firstMethodInterceptor);
        expected.add(shortBeanName);
        ArrayList<String> result = this.getBean().repeatedInterceptors(new ArrayList<String>());
        if (!expected.equals(result)) {
            throw new CalculatorException("Method-level interceptors are not invoked in the correct order. Expecting " + String.valueOf(expected) + ", actual " + String.valueOf(result));
        }
        TLogger.log("Method-level interceptors are invoked in the correct order: " + String.valueOf(result));
    }

    public void interceptorOrderingOverride() throws CalculatorException {
        String firstMethodInterceptor = "InterceptorNoat1";
        String secondMethodInterceptor = "Interceptor1";
        String shortBeanName = "AroundInvokeBean";
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(firstMethodInterceptor);
        expected.add(secondMethodInterceptor);
        expected.add(shortBeanName);
        ArrayList<String> result = this.getBean().interceptorOrderingOverride(new ArrayList<String>());
        if (!expected.equals(result)) {
            throw new CalculatorException("Method-level interceptors are not invoked in the correct order. Expecting " + String.valueOf(expected) + ", actual " + String.valueOf(result));
        }
        TLogger.log("Method-level interceptors are invoked in the correct order: " + String.valueOf(result));
    }

    public void afterBeginTest() throws Exception {
        try {
            this.getBean().afterBeginTest();
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void beforeCompletionTest() throws Exception {
        try {
            this.getBean().beforeCompletionTest();
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    protected abstract AroundInvokeIF getBean();
}

