/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.common;

import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBContext;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenContext;
import jakarta.ejb.TimerService;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;

public abstract class TimerMessageBeanBase {
    public static final String test1 = "test1";
    private MessageDrivenContext messageDrivenContext;
    @Resource(name="qFactory")
    private QueueConnectionFactory qFactory;
    @Resource(name="replyQueue")
    private Queue replyQueue;
    @Resource
    private TimerService timerService;
    private TimerInfo timerInfo = new TimerInfo();

    @Resource(name="messageDrivenContext")
    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) throws EJBException {
        this.messageDrivenContext = messageDrivenContext;
    }

    protected void initTimerInfo(Message msg) {
        boolean status = false;
        String reason = null;
        String testname = null;
        int testNumber = 0;
        try {
            testname = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
            testNumber = msg.getIntProperty("TestCaseNum");
        }
        catch (JMSException e) {
            status = false;
            reason = this.getClass().getName() + "Failed to get test name/number from message: " + String.valueOf(msg);
            this.timerInfo = null;
            throw new EJBException(reason, (Exception)((Object)e));
        }
        if (testname.equals(test1) && testNumber == 0) {
            status = true;
            reason = this.getClass().getName() + " received message from " + testname + ", status " + status;
        } else {
            status = false;
            reason = this.getClass().getName() + "Unrecognized testname: " + testname + ", testnum: " + testNumber;
        }
        this.timerInfo.setTestNumber(testNumber);
        this.timerInfo.setTestName(testname);
        this.timerInfo.setStatus(status);
        this.timerInfo.setReason(reason);
    }

    public EJBContext getEJBContext() {
        return this.getMessageDrivenContext();
    }

    public MessageDrivenContext getMessageDrivenContext() {
        return this.messageDrivenContext;
    }

    public QueueConnectionFactory getQFactory() {
        return this.qFactory;
    }

    public Queue getReplyQueue() {
        return this.replyQueue;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public TimerInfo getTimerInfo() {
        return this.timerInfo;
    }
}

