/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.timerconfig;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.TimerBeanBaseWithoutTimeOutMethod;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.timerconfig.TimerConfigIF;
import jakarta.ejb.Singleton;
import jakarta.ejb.TimedObject;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

@Singleton
public class TimerConfigBean
extends TimerBeanBaseWithoutTimeOutMethod
implements TimedObject,
TimerConfigIF {
    @Timeout
    public void ejbTimeout(Timer timer) {
        this.timeout(timer);
    }

    @Override
    public void resetTimerConfig(String testName, StringBuilder sb) {
        long durationLong = 600000L;
        TimerInfo info1 = new TimerInfo(testName);
        boolean isPersistent1 = false;
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)info1);
        timerConfig.setPersistent(isPersistent1);
        Timer timer = this.createTimer(durationLong, timerConfig);
        TimerInfo info2 = new TimerInfo(testName + testName);
        boolean isPersistent2 = true;
        timerConfig.setInfo((Serializable)info2);
        timerConfig.setPersistent(isPersistent2);
        Helper.assertEquals(null, isPersistent1, timer.isPersistent(), sb);
        Helper.assertEquals(null, info1, timer.getInfo(), sb);
        timer.cancel();
        timerConfig.setInfo(null);
        timer = this.createTimer(durationLong, timerConfig);
        timerConfig.setInfo((Serializable)info1);
        timerConfig.setPersistent(isPersistent1);
        Helper.assertEquals(null, isPersistent2, timer.isPersistent(), sb);
        Helper.assertEquals(null, null, timer.getInfo(), sb);
        timer.cancel();
    }

    @Override
    public void illegalArgumentException(StringBuilder sb, TimerConfig timerConfig) {
        try {
            this.timerService.createSingleActionTimer((Date)null, timerConfig);
            throw new RuntimeException("Expecting IllegalArgumentException, but got none.");
        }
        catch (IllegalArgumentException e) {
            sb.append("Got expected: " + String.valueOf(e));
            try {
                this.timerService.createIntervalTimer(Calendar.getInstance().getTime(), -1L, timerConfig);
                throw new RuntimeException("Expecting IllegalArgumentException, but got none.");
            }
            catch (IllegalArgumentException e2) {
                sb.append("Got expected: " + String.valueOf(e2));
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.set(1, 1968);
                    Date d = cal.getTime();
                    this.timerService.createSingleActionTimer(d, timerConfig);
                    throw new RuntimeException("Expecting IllegalArgumentException for negative date, but got none: " + d.getTime() + "; " + String.valueOf(d));
                }
                catch (IllegalArgumentException e3) {
                    sb.append("Got expected: " + String.valueOf(e3));
                    try {
                        this.timerService.createIntervalTimer((Date)null, 1L, timerConfig);
                        throw new RuntimeException("Expecting IllegalArgumentException, but got none.");
                    }
                    catch (IllegalArgumentException e4) {
                        sb.append("Got expected: " + String.valueOf(e4));
                        try {
                            this.timerService.createSingleActionTimer(-1L, timerConfig);
                            throw new RuntimeException("Expecting IllegalArgumentException, but got none.");
                        }
                        catch (IllegalArgumentException e5) {
                            sb.append("Got expected: " + String.valueOf(e5));
                            try {
                                this.timerService.createIntervalTimer(-1L, 1L, timerConfig);
                                throw new RuntimeException("Expecting IllegalArgumentException, but got none.");
                            }
                            catch (IllegalArgumentException e6) {
                                sb.append("Got expected: " + String.valueOf(e6));
                                try {
                                    this.timerService.createIntervalTimer(1L, -1L, timerConfig);
                                    throw new RuntimeException("Expecting IllegalArgumentException, but got none.");
                                }
                                catch (IllegalArgumentException e7) {
                                    sb.append("Got expected: " + String.valueOf(e7));
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void gettersSetters(StringBuilder sb) {
        TimerConfig timerConfig = new TimerConfig();
        Helper.assertEquals("Check default value of info ", null, timerConfig.getInfo(), sb);
        Helper.assertEquals("Check default value of isPersistent ", true, timerConfig.isPersistent(), sb);
        TimerInfo timerInfo = new TimerInfo();
        this.gettersSetters0(timerConfig, timerInfo, true, sb);
        this.gettersSetters0(timerConfig, timerInfo, false, sb);
        this.gettersSetters0(timerConfig, null, false, sb);
    }

    private void gettersSetters0(TimerConfig timerConfig, Serializable timerInfo, boolean isPersistent, StringBuilder sb) {
        timerConfig.setPersistent(isPersistent);
        timerConfig.setInfo(timerInfo);
        Helper.assertEquals("Check value of info ", timerInfo, timerConfig.getInfo(), sb);
        Helper.assertEquals("Check value of isPersistent ", isPersistent, timerConfig.isPersistent(), sb);
    }
}

