/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.zombie;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import jakarta.annotation.Resource;
import jakarta.ejb.ActivationConfigProperty;
import jakarta.ejb.EJBContext;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.MessageDrivenContext;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;

@MessageDriven(name="MessageBean", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="jakarta.jms.Queue")})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class MessageBean
implements MessageListener {
    @Resource(name="mdc")
    private MessageDrivenContext mdc;

    public EJBContext getEJBContext() {
        return this.mdc;
    }

    public void onMessage(Message msg) {
        Object info = null;
        try {
            String testname = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
            int testNumber = msg.getIntProperty("TestCaseNum");
            info = "COM_SUN_JMS_TESTNAME=" + testname + ", TestCaseNum=" + testNumber;
        }
        catch (JMSException e) {
            info = msg.toString();
        }
        TLogger.log(String.valueOf(this) + " consumed message " + (String)info);
    }
}

